/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.nlj.transform.node.incoming.PaddingTerminationKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/PaddingTermination;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "logger", "numPaddedPacketsSeen", "", "numPaddingOnlyPacketsSeen", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class PaddingTermination
extends TransformerNode {
    @NotNull
    private final Logger logger;
    private int numPaddedPacketsSeen;
    private int numPaddingOnlyPacketsSeen;

    public PaddingTermination(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("Padding termination");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
        if (rtpPacket.getHasPadding()) {
            PaddingTerminationKt.removePadding(rtpPacket);
            packetInfo.resetPayloadVerification();
            int n = this.numPaddedPacketsSeen;
            this.numPaddedPacketsSeen = n + 1;
            if (rtpPacket.getPayloadLength() == 0) {
                n = this.numPaddingOnlyPacketsSeen;
                this.numPaddingOnlyPacketsSeen = n + 1;
                packetInfo.setShouldDiscard(true);
            }
        }
        return packetInfo;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u240.addNumber("num_padded_packets_seen", this.numPaddedPacketsSeen);
        $this$getNodeStats_u24lambda_u240.addNumber("num_padding_only_packets_seen", this.numPaddingOnlyPacketsSeen);
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    public OrderedJsonObject statsJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$statsJson_u24lambda_u241 = orderedJsonObject = super.statsJson();
        boolean bl = false;
        ((Map)$this$statsJson_u24lambda_u241).put("num_padded_packets_seen", this.numPaddedPacketsSeen);
        ((Map)$this$statsJson_u24lambda_u241).put("num_padding_only_packets_seen", this.numPaddingOnlyPacketsSeen);
        return orderedJsonObject;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

