/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import lts.Alphabet;
import lts.Automata;
import lts.LTSOutput;
import lts.MyHashProg;
import lts.MyHashProgEntry;
import lts.MyList;
import lts.MyStack;
import lts.ProgressTest;
import lts.StateCodec;

public class ProgressCheck {
    private Automata mach;
    private Stack stack;
    int id = 0;
    int ncomp = 0;
    LTSOutput output;
    int violation = 0;
    boolean hasERROR = false;
    static final int Maxviolation = 10;
    String tnames;
    private int sccId;
    private int nTrans;
    Vector errorTrace;

    public ProgressCheck(Automata automata, LTSOutput lTSOutput) {
        this.mach = automata;
        this.output = lTSOutput;
        this.output.outln("Progress Check...");
        long l = System.currentTimeMillis();
        ProgressTest.initTests(automata.getAlphabet());
        this.stack = new Stack();
        this.findCC();
        long l2 = System.currentTimeMillis();
        if (this.hasERROR) {
            this.output.outln("Safety property violation detected - check safety.");
        } else if (this.violation == 0) {
            this.output.outln("No progress violations detected.");
        } else if (this.violation > 10) {
            this.output.outln("More than 10 violations");
        }
        this.output.outln("Progress Check in: " + (l2 - l) + "ms");
    }

    public int numberComponents() {
        return this.ncomp;
    }

    private void findCC() {
        MyHashProg myHashProg = new MyHashProg();
        MyStack myStack = new MyStack();
        this.mach.setStackChecker(myHashProg);
        this.sccId = 0;
        this.nTrans = 0;
        byte[] byArray = this.mach.START();
        myStack.push(byArray);
        myHashProg.add(byArray, null);
        while (!myStack.empty()) {
            MyHashProgEntry myHashProgEntry = myHashProg.get(myStack.peek());
            while (myHashProgEntry.isReturn || myHashProgEntry.isProcessed) {
                if (myHashProgEntry.isReturn && !myHashProgEntry.isProcessed) {
                    myHashProgEntry.isProcessed = true;
                    if (myHashProgEntry.parent != null) {
                        myHashProgEntry.parent.low = Math.min(myHashProgEntry.parent.low, myHashProgEntry.low);
                    }
                    if (myHashProgEntry.low == myHashProgEntry.dfn && this.component(myHashProg, this.stack, myHashProgEntry.key)) {
                        return;
                    }
                }
                myStack.pop();
                if (myStack.empty()) {
                    this.outStatistics(this.sccId, this.nTrans);
                    return;
                }
                myHashProgEntry = myHashProg.get(myStack.peek());
            }
            myHashProgEntry.dfn = ++this.sccId;
            myHashProgEntry.low = this.sccId;
            if (this.sccId % 10000 == 0) {
                this.outStatistics(this.sccId, this.nTrans);
            }
            this.stack.push(myHashProgEntry.key);
            myHashProgEntry.isReturn = true;
            MyList myList = this.mach.getTransitions(myHashProgEntry.key);
            while (!myList.empty()) {
                ++this.nTrans;
                if (myList.getTo() == null) {
                    this.hasERROR = true;
                    return;
                }
                MyHashProgEntry myHashProgEntry2 = myHashProg.get(myList.getTo());
                if (myHashProgEntry2 == null) {
                    myHashProg.add(myList.getTo(), myHashProgEntry);
                    myStack.push(myList.getTo());
                } else if (myHashProgEntry2.dfn == 0) {
                    myHashProgEntry2.parent = myHashProgEntry;
                    myStack.push(myList.getTo());
                } else if (myHashProgEntry2.dfn < myHashProgEntry.dfn) {
                    myHashProgEntry.low = Math.min(myHashProgEntry2.dfn, myHashProgEntry.low);
                }
                myList.next();
            }
        }
        this.outStatistics(this.sccId, this.nTrans);
    }

    private void outhse(MyHashProgEntry myHashProgEntry) {
        this.output.outln("state: " + myHashProgEntry.key + " dfn: " + myHashProgEntry.dfn + " low: " + myHashProgEntry.low + " ret " + myHashProgEntry.isReturn);
    }

    private boolean component(MyHashProg myHashProg, Stack stack, byte[] byArray) {
        Object object;
        byte[] byArray2;
        ++this.ncomp;
        boolean bl = false;
        Stack stack2 = new Stack();
        BitSet bitSet = new BitSet(this.mach.getAlphabet().length);
        do {
            stack2.push(stack.pop());
            byArray2 = (byte[])stack2.peek();
            object = this.mach.getTransitions(byArray2);
            while (!((MyList)object).empty()) {
                bitSet.set(((MyList)object).getAction());
                ((MyList)object).next();
            }
        } while (!StateCodec.equals(byArray2, byArray));
        if (this.missing(bitSet) && this.terminalComponent(myHashProg, stack2)) {
            this.outStatistics(this.sccId, this.nTrans);
            this.printCycle(stack2, bitSet, byArray);
            return true;
        }
        object = stack2.elements();
        while (object.hasMoreElements()) {
            byte[] byArray3 = (byte[])object.nextElement();
            MyHashProgEntry myHashProgEntry = myHashProg.get(byArray3);
            myHashProgEntry.dfn = Integer.MAX_VALUE;
        }
        return false;
    }

    private boolean missing(BitSet bitSet) {
        int n = this.mach.getAlphabet().length;
        if (ProgressTest.noTests()) {
            int n2 = 1;
            while (n2 < n) {
                if (!bitSet.get(n2)) {
                    return true;
                }
                ++n2;
            }
        } else {
            this.tnames = null;
            Enumeration enumeration = ProgressTest.tests.elements();
            while (enumeration.hasMoreElements()) {
                ProgressTest progressTest = (ProgressTest)enumeration.nextElement();
                if (progressTest.cset == null) {
                    if (!this.contains_none_of(n, bitSet, progressTest.pset)) continue;
                    if (this.tnames == null) {
                        this.tnames = progressTest.name;
                        continue;
                    }
                    this.tnames = this.tnames + " " + progressTest.name;
                    continue;
                }
                if (this.contains_none_of(n, bitSet, progressTest.pset) || !this.contains_none_of(n, bitSet, progressTest.cset)) continue;
                this.tnames = this.tnames == null ? progressTest.name : this.tnames + " " + progressTest.name;
            }
            if (this.tnames != null) {
                return true;
            }
        }
        return false;
    }

    private boolean contains_none_of(int n, BitSet bitSet, BitSet bitSet2) {
        int n2 = 1;
        while (n2 < n) {
            if (bitSet.get(n2) && bitSet2.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean terminalComponent(MyHashProg myHashProg, Vector vector) {
        Object object;
        Object object2;
        BitSet bitSet = new BitSet(10001);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (byte[])enumeration.nextElement();
            object = myHashProg.get((byte[])object2);
            bitSet.set(((MyHashProgEntry)object).dfn);
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (byte[])object2.nextElement();
            MyList myList = this.mach.getTransitions((byte[])object);
            while (!myList.empty()) {
                if (myList.getTo() == null) {
                    this.hasERROR = true;
                    return false;
                }
                MyHashProgEntry myHashProgEntry = myHashProg.get(myList.getTo());
                if (myHashProgEntry == null) {
                    return false;
                }
                if (myHashProgEntry.dfn == 0) {
                    return false;
                }
                if (myHashProgEntry.dfn == Integer.MAX_VALUE) {
                    return false;
                }
                if (!bitSet.get(myHashProgEntry.dfn)) {
                    return false;
                }
                myList.next();
            }
        }
        return true;
    }

    private void printSet(BitSet bitSet, boolean bl) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.mach.getAlphabet();
        int n = 1;
        while (n < stringArray.length) {
            if (bl && !bitSet.get(n) || !bl && bitSet.get(n)) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        this.output.outln("\t" + new Alphabet(vector).toString());
    }

    Vector getErrorTrace() {
        return this.errorTrace;
    }

    private void printCycle(Stack stack, BitSet bitSet, byte[] byArray) {
        ++this.violation;
        if (this.violation > 10) {
            return;
        }
        this.output.outln("Finding trace...");
        this.errorTrace = this.mach.getTraceToState(byArray);
        if (this.errorTrace == null) {
            this.hasERROR = true;
            return;
        }
        if (ProgressTest.noTests()) {
            this.output.outln("Progress violation for actions: ");
            this.printSet(bitSet, true);
        } else {
            this.output.outln("Progress violation: " + this.tnames);
        }
        this.output.outln("Trace to terminal set of states:");
        Enumeration enumeration = this.errorTrace.elements();
        while (enumeration.hasMoreElements()) {
            this.output.outln("\t" + (String)enumeration.nextElement());
        }
        this.output.outln("Actions in terminal set:");
        this.printSet(bitSet, false);
    }

    private void outStatistics(int n, int n2) {
        Runtime runtime = Runtime.getRuntime();
        this.output.outln("-- States: " + n + " Transitions: " + n2 + " Memory used: " + (runtime.totalMemory() - runtime.freeMemory()) / 1000L + "K");
    }
}

