/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelui.parsing.ParsingProblemResolver;
import org.netbeans.modules.cnd.spi.model.services.CodeModelProblemResolver;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.NbBundle;

public class ParsingProblemDetectorImpl
implements CodeModelProblemResolver.ParsingProblemDetector {
    private static final Logger LOG = Logger.getLogger("cnd.parsing.problem.detector");
    public static final boolean TIMING = Boolean.getBoolean("cnd.modelimpl.timing");
    private static final int Mb = 0x100000;
    private static final int timeThreshold = 60000;
    private final Runtime runtime = Runtime.getRuntime();
    public final int maxMemory = (int)(this.runtime.maxMemory() / 0x100000L);
    private final int startMemory;
    private int lineCount;
    private long startTime;
    private AverageSpeed averageSpeed;
    private final List<Measure> measures;
    private final int memoryThreshold = Math.max(this.maxMemory / 10, 10);
    private final CsmProject project;
    private long remainingTime = 0L;
    private static boolean isDialogShown = false;

    public ParsingProblemDetectorImpl(CsmProject project) {
        this.startMemory = (int)((this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L);
        this.measures = new ArrayList<Measure>();
        this.project = project;
    }

    public void start() {
    }

    public void finish() {
        int parsingTime;
        int lines;
        if (this.measures.size() > 1 && (lines = this.measures.get((int)(this.measures.size() - 1)).lines) > 0 && (parsingTime = this.measures.get((int)(this.measures.size() - 1)).time) > 0) {
            int parsingMemory = 0;
            for (Measure m : this.measures) {
                parsingMemory = Math.max(parsingMemory, m.memory);
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Parsing statistic of ").append(this.project.getDisplayName()).append(":\n");
            buf.append("Parsed ").append(lines / 1000).append(" KLines, Time ").append(parsingTime / 1000).append(" seconds, Speed ").append(lines / parsingTime).append(" KLines/second, Max Memory ").append(parsingMemory).append(" Mb\n");
            int currentPercent = 1;
            int curentTime = 0;
            int curentLines = 0;
            buf.append("Work, %\t\tSpeed, KLines/second\tMemory, Mb\n");
            for (Measure m : this.measures) {
                int p = m.lines * 100 / lines;
                if (p - currentPercent * 5 < 0) continue;
                int l = m.lines - curentLines;
                curentLines = m.lines;
                int t = m.time - curentTime;
                curentTime = m.time;
                ++currentPercent;
                if (t == 0) continue;
                buf.append("\t").append(p).append("\t\t").append(l / t).append("\t\t").append(m.memory).append("\n");
            }
            LOG.log(Level.INFO, buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Measure> getData() {
        ArrayList<Measure> res = new ArrayList<Measure>();
        List<Measure> list = this.measures;
        synchronized (list) {
            res.addAll(this.measures);
        }
        return res;
    }

    private void showWarning() {
        if (isDialogShown) {
            return;
        }
        if (CndUtils.isStandalone() || CndUtils.isUnitTestMode()) {
            return;
        }
        if (this.remainingTime < 60000L) {
            return;
        }
        int usedMemory = (int)((this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L);
        if (this.maxMemory - usedMemory < this.memoryThreshold) {
            isDialogShown = true;
            LOG.log(Level.INFO, "Lack of Memory, Heap Size={0}Mb, Used Memory={1}Mb", new Object[]{this.maxMemory, usedMemory});
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParsingProblemResolver.showParsingProblemResolver(ParsingProblemDetectorImpl.this);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextCsmFile(CsmFile file, int fileLineCount, int current, int allWork) {
        String msg = "";
        int usedMemory = (int)((this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L);
        long currentTimeMillis = System.currentTimeMillis();
        long delta = currentTimeMillis - this.startTime;
        if (TIMING) {
            this.lineCount += fileLineCount;
            List<Measure> list = this.measures;
            synchronized (list) {
                this.measures.add(new Measure(this.lineCount, (int)delta, usedMemory));
            }
        }
        if (this.averageSpeed != null) {
            this.averageSpeed.add(currentTimeMillis);
            this.remainingTime = this.averageSpeed.getEstimation(this.startTime, delta, current, allWork);
        }
        if (this.maxMemory - usedMemory < this.memoryThreshold) {
            msg = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"MSG_LowMemory");
        }
        this.showWarning();
        return msg;
    }

    public String getRemainingTime() {
        String esimation;
        if (this.remainingTime == 0L) {
            return "";
        }
        if (this.remainingTime < 1000L) {
            esimation = "";
        } else if (this.remainingTime < 60000L) {
            int s = (int)(this.remainingTime / 1000L);
            esimation = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Remaining_seconds", (Object)("" + s));
        } else if (this.remainingTime < 3600000L) {
            int s = (int)(this.remainingTime / 1000L / 60L);
            esimation = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Remaining_minutes", (Object)("" + s));
        } else {
            int s = (int)(this.remainingTime / 1000L / 60L / 60L);
            esimation = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Remaining_hours", (Object)("" + s));
        }
        return esimation;
    }

    public void switchToDeterminate(int maxWorkUnits) {
        this.startTime = System.currentTimeMillis();
        this.averageSpeed = new AverageSpeed(this.startTime);
    }

    private static final class AverageSpeed {
        private static final int MOVING_AVERAGE = 60;
        private final int[] last = new int[60];
        private long movingStartTime;

        private AverageSpeed(long startTime) {
            this.movingStartTime = startTime;
        }

        private void add(long currentTime) {
            int delta = (int)((currentTime - this.movingStartTime) / 1000L);
            if (delta < 0) {
                return;
            }
            if (delta >= 60) {
                int shift = 1 + delta - 60;
                for (int i = 0; i < 60; ++i) {
                    this.last[i] = i + shift < 60 ? this.last[i + shift] : 0;
                }
                this.movingStartTime += (long)(shift * 1000);
                delta -= shift;
            }
            int n = delta;
            this.last[n] = this.last[n] + 1;
        }

        private long getEstimation(long startTime, long delta, int current, int allWork) {
            if (current < 10) {
                return 0L;
            }
            long interval = startTime + delta - this.movingStartTime;
            if (interval / 1000L > 30L) {
                int work = 0;
                for (int i = 0; i < 60; ++i) {
                    work += this.last[i];
                }
                if (work > 0) {
                    return interval * (long)(allWork - current) / (long)work;
                }
            }
            return delta * (long)(allWork - current) / (long)current;
        }
    }

    public static final class Measure {
        public final int lines;
        public final int time;
        public final int memory;

        Measure(int lines, int time, int memory) {
            this.lines = lines;
            this.time = time;
            this.memory = memory;
        }
    }
}

