/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteLogger;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.FileCollector;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.remote.sync.Zipper;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.setup.support.RemoteSyncNotifier;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class FtpSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker,
Cancellable {
    private FileData fileData;
    private FileCollector fileCollector;
    private final RemoteUtil.PrefixedLogger logger;
    private final RemotePathMap mapper;
    private final SharabilityFilter filter;
    private int uploadCount;
    private long uploadSize;
    private volatile Thread thread;
    private volatile boolean cancelled;
    private ProgressHandle progressHandle;
    private final RequestProcessor RP = new RequestProcessor("FtpSyncWorker", 3);
    private static final boolean HARD_CODED_FILTER = Boolean.valueOf(System.getProperty("cnd.remote.hardcoded.filter", "true"));

    public FtpSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, FileObject privProjectStorageDir, List<FSPath> paths, List<FSPath> buildResults) {
        super(executionEnvironment, out, err, privProjectStorageDir, paths, buildResults);
        this.mapper = RemotePathMap.getPathMap(executionEnvironment);
        this.logger = new RemoteUtil.PrefixedLogger("FtpSyncWorker[" + executionEnvironment + "]");
        this.filter = new SharabilityFilter();
    }

    private StringBuilder getLocalFilesString() {
        StringBuilder sb = new StringBuilder();
        for (File f : this.files) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f.getAbsolutePath());
        }
        return sb;
    }

    private boolean isIgnored(FileCollector.FileCollectorInfo collectorInfo) {
        File granpa;
        File parent;
        File file = collectorInfo.file;
        return HARD_CODED_FILTER && (parent = file.getParentFile()) != null && (parent.getName().equals("nbproject") ? file.getName().equals("configurations.xml") : parent.getName().equals("private") && (granpa = parent.getParentFile()).getName().equals("nbproject") && !file.getName().endsWith(".mk") && !file.getName().endsWith(".sh") && !file.getName().endsWith(".bash"));
    }

    private boolean needsCopying(FileCollector.FileCollectorInfo collectorInfo) {
        File file = collectorInfo.file;
        if (!file.exists()) {
            return false;
        }
        if (this.isIgnored(collectorInfo)) {
            return false;
        }
        FileData.FileStateInfo stateInfo = this.fileData.getFileInfo(file);
        FileState state = stateInfo == null ? FileState.INITIAL : stateInfo.state;
        switch (state) {
            case INITIAL: {
                return true;
            }
            case TOUCHED: {
                return true;
            }
            case COPIED: {
                return stateInfo.timestamp != file.lastModified();
            }
            case ERROR: {
                return true;
            }
            case INEXISTENT: {
                return false;
            }
            case UNCONTROLLED: {
                return false;
            }
        }
        CndUtils.assertTrue((boolean)false, (String)("Unexpected state: " + (Object)((Object)state)));
        return false;
    }

    private void synchronizeImpl(String remoteRoot) throws InterruptedException, ExecutionException, IOException, ConnectionManager.CancellationException {
        this.fileData = FileData.get(this.privProjectStorageDir, this.executionEnvironment);
        this.fileCollector = new FileCollector(this.files, this.buildResults, this.logger, this.mapper, this.filter, this.fileData, this.executionEnvironment, this.err);
        this.uploadCount = 0;
        this.uploadSize = 0L;
        RemoteLogger.fine("Uploading {0} to {1} ...\n", this.getLocalFilesString(), this.executionEnvironment);
        long time = System.currentTimeMillis();
        this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_GatherFiles"));
        this.fileCollector.gatherFiles();
        if (this.cancelled) {
            return;
        }
        this.progressHandle.switchToDeterminate(this.fileCollector.getFiles().size());
        long time2 = System.currentTimeMillis();
        this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_CheckDirs"));
        this.progressHandle.progress(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Progress_CheckDirs"));
        this.createDirs();
        RemoteLogger.fine("Creating directories at {0} took {1} ms", this.executionEnvironment, System.currentTimeMillis() - time2);
        if (this.cancelled) {
            return;
        }
        if (CndUtils.getBoolean((String)"cnd.remote.sftp.check.existence", (boolean)true)) {
            time2 = System.currentTimeMillis();
            this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_CheckExistence"));
            this.progressHandle.progress(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Progress_CheckExistence"));
            this.checkExistence();
            RemoteLogger.fine("Checking file existence at {0} took {1} ms", this.executionEnvironment, System.currentTimeMillis() - time2);
            if (this.cancelled) {
                return;
            }
        }
        time2 = System.currentTimeMillis();
        this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_CheckLinks"));
        this.progressHandle.progress(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Progress_CheckLinks"));
        this.createLinks();
        RemoteLogger.fine("Creating links at {0} took {1} ms", this.executionEnvironment, System.currentTimeMillis() - time2);
        if (this.cancelled) {
            return;
        }
        if (!this.fileCollector.initNewFilesDiscovery()) {
            throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_NewFilesDiscovery"));
        }
        time2 = System.currentTimeMillis();
        if (CndUtils.getBoolean((String)"cnd.remote.zip", (boolean)true)) {
            try {
                this.uploadPlainFilesInZip(remoteRoot);
                RemoteLogger.fine("Uploading and extracting zip to {0} took {1} ms", this.executionEnvironment, System.currentTimeMillis() - time2);
            }
            catch (ZipIOException ex) {
                time2 = System.currentTimeMillis();
                this.err.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_TryingToRecoverViaPlainFiles"));
                this.uploadPlainFiles();
                RemoteLogger.fine("Uploading plain files to {0} took {1} ms", this.executionEnvironment, System.currentTimeMillis() - time2);
            }
        } else {
            this.uploadPlainFiles();
        }
        time2 = System.currentTimeMillis();
        this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_CheckExecPerm"));
        this.progressHandle.progress(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Progress_CheckExecPerm"));
        this.addExecPermissions();
        RemoteLogger.fine("Checkinrg exec permissions at {0} took {1} ms", this.executionEnvironment, System.currentTimeMillis() - time2);
        if (this.cancelled) {
            return;
        }
        this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_Done"));
        this.out.println();
        if (RemoteLogger.getInstance().isLoggable(Level.FINE)) {
            time = System.currentTimeMillis() - time;
            long bps = this.uploadSize * 1000L / time;
            String speed = bps < 8192L ? bps + " b/s" : bps / 1024L + " Kb/s";
            String strUploadSize = this.uploadSize < 1024L ? this.uploadSize + " bytes" : this.uploadSize / 1024L + " K";
            RemoteLogger.fine("\nCopied to {0}:{1}: {2} in {3} files. Time: {4} ms. Avg. speed: {5}\n", this.executionEnvironment, remoteRoot, strUploadSize, this.uploadCount, time, speed);
        }
    }

    private void launchAndFeed(final Feeder feeder, final LineProcessor outProcessor, final LineProcessor errProcessor, boolean throwUponFailure, String command, String ... args) throws IOException {
        if (this.cancelled) {
            return;
        }
        NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
        pb.setExecutable(command);
        pb.setArguments(args);
        final NativeProcess process = pb.call();
        final AtomicReference problem = new AtomicReference();
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                BufferedWriter requestWriter = null;
                try {
                    requestWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), "UTF-8"));
                    feeder.feed(requestWriter);
                }
                catch (IOException ex) {
                    problem.set(ex);
                }
                finally {
                    if (requestWriter != null) {
                        try {
                            requestWriter.close();
                        }
                        catch (IOException ex) {
                            problem.set(ex);
                        }
                    }
                }
            }
        });
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                BufferedReader errorReader = null;
                try {
                    errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8"));
                    String errLine = errorReader.readLine();
                    while (errLine != null) {
                        if (errProcessor != null) {
                            errProcessor.processLine(errLine);
                        } else {
                            FtpSyncWorker.this.err.println(errLine);
                        }
                        errLine = errorReader.readLine();
                    }
                }
                catch (IOException ex) {
                    problem.set(ex);
                }
                finally {
                    if (errorReader != null) {
                        try {
                            errorReader.close();
                        }
                        catch (IOException ex) {
                            problem.set(ex);
                        }
                    }
                }
            }
        });
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                BufferedReader outputReader = null;
                try {
                    outputReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
                    String errLine = outputReader.readLine();
                    while (errLine != null) {
                        if (outProcessor != null) {
                            outProcessor.processLine(errLine);
                        } else {
                            FtpSyncWorker.this.out.println(errLine);
                        }
                        errLine = outputReader.readLine();
                    }
                }
                catch (IOException ex) {
                    problem.set(ex);
                }
                finally {
                    if (outputReader != null) {
                        try {
                            outputReader.close();
                        }
                        catch (IOException ex) {
                            problem.set(ex);
                        }
                    }
                }
            }
        });
        if (problem.get() != null) {
            throw (IOException)problem.get();
        }
        try {
            int rc = process.waitFor();
            if (rc != 0 && throwUponFailure) {
                throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_NonzeroRC", (Object)command, (Object)rc));
            }
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException();
        }
    }

    private void createDirs() throws IOException {
        final LinkedList<String> dirsToCreate = new LinkedList<String>();
        for (FileCollector.FileCollectorInfo fileInfo : this.fileCollector.getFiles()) {
            if (!fileInfo.file.isDirectory() || fileInfo.isLink()) continue;
            String remoteDir = this.mapper.getRemotePath(fileInfo.file.getAbsolutePath(), true);
            CndUtils.assertNotNull((Object)remoteDir, (String)("null remote file for " + fileInfo.file.getAbsolutePath()));
            if (remoteDir == null) continue;
            dirsToCreate.add(remoteDir);
        }
        if (this.cancelled) {
            return;
        }
        if (!dirsToCreate.isEmpty()) {
            Feeder feeder = new Feeder(){

                @Override
                public void feed(BufferedWriter requestWriter) throws IOException {
                    for (String dir : dirsToCreate) {
                        if (FtpSyncWorker.this.cancelled) {
                            throw new InterruptedIOException();
                        }
                        requestWriter.append('\"').append(dir).append('\"').append(' ');
                    }
                }
            };
            try {
                this.launchAndFeed(feeder, null, null, true, "xargs", "mkdir", "-p");
            }
            catch (InterruptedIOException ex) {
                throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_Canceled"));
            }
            catch (IOException ex) {
                throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_CheckDirs", (Object)(ex.getMessage() == null ? "" : ex.getMessage())), ex);
            }
            this.uploadCount += dirsToCreate.size();
            this.progressHandle.progress(this.uploadCount);
        }
    }

    private void addExecPermissions() throws IOException {
        final LinkedList<String> filesToAdd = new LinkedList<String>();
        for (FileCollector.FileCollectorInfo fileInfo : this.fileCollector.getFiles()) {
            if (fileInfo.file.isDirectory() || !fileInfo.file.canExecute() || this.isIgnored(fileInfo)) continue;
            String remotePath = this.mapper.getRemotePath(fileInfo.file.getAbsolutePath(), true);
            CndUtils.assertNotNull((Object)remotePath, (String)("null remote file for " + fileInfo.file.getAbsolutePath()));
            if (remotePath == null) continue;
            filesToAdd.add(remotePath);
        }
        if (this.cancelled) {
            return;
        }
        if (!filesToAdd.isEmpty()) {
            Feeder feeder = new Feeder(){

                @Override
                public void feed(BufferedWriter requestWriter) throws IOException {
                    for (String dir : filesToAdd) {
                        if (FtpSyncWorker.this.cancelled) {
                            throw new InterruptedIOException();
                        }
                        requestWriter.append('\"').append(dir).append('\"').append(' ');
                    }
                }
            };
            try {
                this.launchAndFeed(feeder, null, null, false, "xargs", "chmod", "+x");
            }
            catch (InterruptedIOException ex) {
                throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_Canceled"));
            }
            catch (IOException ex) {
                throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_CheckDirs", (Object)(ex.getMessage() == null ? "" : ex.getMessage())), ex);
            }
        }
    }

    private void checkExistence() throws IOException {
        if (this.cancelled) {
            return;
        }
        boolean needToCheck = false;
        for (FileCollector.FileCollectorInfo collectorInfo : this.fileCollector.getFiles()) {
            FileData.FileStateInfo stateInfo;
            if (collectorInfo.isLink() || !collectorInfo.file.isFile() || !collectorInfo.file.exists() || (stateInfo = this.fileData.getFileInfo(collectorInfo.file)) == null || stateInfo.state != FileState.COPIED) continue;
            needToCheck = true;
            break;
        }
        if (!needToCheck) {
            return;
        }
        Feeder feeder = new Feeder(){
            private boolean mapErrorReported = false;

            @Override
            public void feed(BufferedWriter requestWriter) throws IOException {
                for (FileCollector.FileCollectorInfo collectorInfo : FtpSyncWorker.this.fileCollector.getFiles()) {
                    FileData.FileStateInfo stateInfo;
                    if (collectorInfo.isLink() || !collectorInfo.file.isFile() || !collectorInfo.file.exists() || (stateInfo = FtpSyncWorker.this.fileData.getFileInfo(collectorInfo.file)) == null || stateInfo.state != FileState.COPIED) continue;
                    String localPath = collectorInfo.file.getAbsolutePath();
                    String remotePath = FtpSyncWorker.this.mapper.getRemotePath(localPath, false);
                    if (remotePath != null) {
                        String line = "if [ ! -f \"" + remotePath + "\" ]; then echo \"" + remotePath + "\"; fi\n";
                        requestWriter.append(line);
                        continue;
                    }
                    if (remotePath != null || this.mapErrorReported || !CndUtils.isDebugMode()) continue;
                    this.mapErrorReported = true;
                    CndUtils.assertUnconditional((String)("null remote file for " + collectorInfo.file.getAbsolutePath()));
                }
            }
        };
        LineProcessor outProcessor = new LineProcessor(){
            private boolean mapErrorReported = false;

            @Override
            public void processLine(String line) {
                String localPath = FtpSyncWorker.this.mapper.getLocalPath(line, false);
                if (localPath != null) {
                    FtpSyncWorker.this.fileData.setState(new File(localPath), FileState.INITIAL);
                } else if (!this.mapErrorReported && CndUtils.isDebugMode()) {
                    this.mapErrorReported = true;
                    CndUtils.assertUnconditional((String)("null local file for " + line));
                }
            }
        };
        try {
            this.launchAndFeed(feeder, outProcessor, null, true, "sh", "-s");
        }
        catch (InterruptedIOException ex) {
            throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_Canceled"));
        }
        catch (IOException ex) {
            this.err.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_CheckExistence", (Object)ex.getLocalizedMessage()));
        }
    }

    private void createLinks() throws IOException {
        if (this.cancelled) {
            return;
        }
        Feeder feeder = new Feeder(){

            @Override
            public void feed(BufferedWriter requestWriter) throws IOException {
                for (FileCollector.FileCollectorInfo fileInfo : FtpSyncWorker.this.fileCollector.getFiles()) {
                    if (FtpSyncWorker.this.cancelled) {
                        throw new InterruptedIOException();
                    }
                    if (!fileInfo.isLink()) continue;
                    FtpSyncWorker.this.progressHandle.progress(fileInfo.file.getAbsolutePath());
                    String localBaseDir = fileInfo.file.getParentFile().getAbsolutePath();
                    String remoteBaseDir = FtpSyncWorker.this.mapper.getRemotePath(localBaseDir, true);
                    CndUtils.assertNotNull((Object)remoteBaseDir, (String)("null remote dir for " + localBaseDir));
                    if (remoteBaseDir != null) {
                        requestWriter.append("cd ").append(remoteBaseDir).append('\n');
                        requestWriter.append("rm -rf ").append(fileInfo.file.getName()).append('\n');
                        requestWriter.append("ln -s ").append(fileInfo.getLinkTarget()).append(' ').append(fileInfo.file.getName()).append('\n');
                    }
                    FtpSyncWorker.this.progressHandle.progress(fileInfo.file.getName(), FtpSyncWorker.this.uploadCount++);
                }
            }
        };
        try {
            this.launchAndFeed(feeder, null, null, true, "sh", "-s");
        }
        catch (InterruptedIOException ex) {
            throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_Canceled"));
        }
        catch (IOException ex) {
            throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_CheckLinks", (Object)(ex.getMessage() == null ? "" : ex.getMessage())), ex);
        }
    }

    private void uploadPlainFiles() throws InterruptedException, ExecutionException, IOException {
        ArrayList<FileCollector.FileCollectorInfo> toCopy = new ArrayList<FileCollector.FileCollectorInfo>();
        for (FileCollector.FileCollectorInfo fileInfo : this.fileCollector.getFiles()) {
            if (this.cancelled) {
                throw new InterruptedException();
            }
            if (fileInfo.isLink() || fileInfo.file.isDirectory() || !this.needsCopying(fileInfo)) continue;
            toCopy.add(fileInfo);
        }
        if (toCopy.isEmpty()) {
            this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_NoFilesToUpload"));
            return;
        }
        this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_UploadFilesPlain", (Object)toCopy.size()));
        for (FileCollector.FileCollectorInfo fileInfo : toCopy) {
            if (this.cancelled) {
                return;
            }
            if (fileInfo.isLink() || fileInfo.file.isDirectory()) continue;
            if (this.needsCopying(fileInfo)) {
                File srcFile = fileInfo.file;
                this.progressHandle.progress(srcFile.getAbsolutePath());
                String remotePath = this.mapper.getRemotePath(srcFile.getAbsolutePath(), false);
                Future fileTask = CommonTasksSupport.uploadFile((String)srcFile.getAbsolutePath(), (ExecutionEnvironment)this.executionEnvironment, (String)remotePath, (int)(srcFile.canExecute() ? 448 : 384));
                CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)fileTask.get();
                if (uploadStatus.isOK()) {
                    this.fileData.setState(srcFile, FileState.COPIED);
                    this.uploadSize += srcFile.length();
                } else {
                    if (this.err != null) {
                        this.err.println(uploadStatus.getError());
                    }
                    throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Msg_Err_UploadFile", (Object)srcFile, (Object)this.executionEnvironment, (Object)remotePath, (Object)uploadStatus.getExitCode(), (Object[])new Object[0]));
                }
            }
            this.progressHandle.progress(this.uploadCount++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadPlainFilesInZip(String remoteRoot) throws InterruptedException, ExecutionException, IOException {
        ArrayList<FileCollector.FileCollectorInfo> toCopy;
        block22: {
            this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_UploadFilesInZip"));
            toCopy = new ArrayList<FileCollector.FileCollectorInfo>();
            for (FileCollector.FileCollectorInfo fileInfo : this.fileCollector.getFiles()) {
                if (this.cancelled) {
                    throw new InterruptedException();
                }
                if (fileInfo.isLink() || fileInfo.file.isDirectory() || !this.needsCopying(fileInfo)) continue;
                toCopy.add(fileInfo);
            }
            if (toCopy.isEmpty()) {
                return;
            }
            this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_Zipping", (Object)toCopy.size()));
            this.progressHandle.progress(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Progress_Zipping"));
            File zipFile = null;
            String remoteFile = null;
            try {
                String localFileName = this.files[0].getName();
                if (localFileName.length() < 3) {
                    localFileName = localFileName + (localFileName.length() == 1 ? "__" : "_");
                }
                zipFile = File.createTempFile(localFileName, ".zip", FtpSyncWorker.getTemp());
                Zipper zipper = new Zipper(zipFile);
                RemoteLogger.fine("SFTP/ZIP: Zipping {0} to {1}...", this.getLocalFilesString(), zipFile);
                long zipTime = System.currentTimeMillis();
                int progress = 0;
                for (FileCollector.FileCollectorInfo fileInfo : toCopy) {
                    if (this.cancelled) {
                        throw new InterruptedException();
                    }
                    File srcFile = fileInfo.file;
                    String remoteDir = this.mapper.getRemotePath(srcFile.getParent(), false);
                    if (remoteDir == null) {
                        throw new IOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Err_CantMap", (Object)srcFile.getAbsolutePath()));
                    }
                    if (!remoteDir.startsWith(remoteRoot)) {
                        throw new IOException(remoteDir + " should start with " + remoteRoot);
                    }
                    String base = remoteDir.substring(remoteRoot.length() + 1);
                    zipper.add(srcFile, this.filter, base);
                    if (progress++ % 3 != 0) continue;
                    this.progressHandle.progress(srcFile.getName(), this.uploadCount++);
                }
                zipper.close();
                RemoteLogger.fine("SFTP/ZIP: Zipping {0} files to {1} took {2} ms\n", toCopy.size(), zipFile, System.currentTimeMillis() - zipTime);
                if (this.cancelled) {
                    throw new InterruptedException();
                }
                this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_UploadingZip", (Object)this.executionEnvironment));
                this.progressHandle.progress(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Progress_UploadingZip"));
                remoteFile = remoteRoot + '/' + zipFile.getName();
                long uploadStart = System.currentTimeMillis();
                Future upload = CommonTasksSupport.uploadFile((String)zipFile.getAbsolutePath(), (ExecutionEnvironment)this.executionEnvironment, (String)remoteFile, (int)384);
                CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)upload.get();
                RemoteLogger.fine("SFTP/ZIP:  uploading {0}to {1}:{2} finished in {3} ms with rc={4}", zipFile, this.executionEnvironment, remoteFile, System.currentTimeMillis() - uploadStart, uploadStatus.getExitCode());
                if (!uploadStatus.isOK()) {
                    throw new IOException(uploadStatus.getError());
                }
                if (this.cancelled) {
                    throw new InterruptedException();
                }
                this.out.println(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Message_Unzipping", (Object)this.executionEnvironment));
                this.progressHandle.progress(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Progress_Unzipping"), this.uploadCount += toCopy.size() / 3);
                long unzipTime = System.currentTimeMillis();
                NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                pb.getEnvironment().put("TZ", TimeZone.getDefault().getID());
                pb.setExecutable("unzip");
                pb.setArguments(new String[]{"-oqq", remoteFile});
                pb.setWorkingDirectory(remoteRoot);
                ProcessUtils.ExitStatus status = ProcessUtils.execute((NativeProcessBuilder)pb);
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST) && !status.getOutputString().isEmpty()) {
                    for (String s : status.getOutputString().split("\n")) {
                        System.out.printf("\tunzip: %s%n", s);
                    }
                }
                if (!status.getErrorString().isEmpty()) {
                    for (String s : status.getErrorString().split("\n")) {
                        this.err.printf("unzip: %s%n", s);
                    }
                }
                RemoteLogger.fine("SFTP/ZIP: Unzipping {0}:{1} finished in {2} ms; rc={3}", this.executionEnvironment, remoteFile, System.currentTimeMillis() - unzipTime, status.exitCode);
                if (status.exitCode != 0) {
                    throw new ZipIOException(NbBundle.getMessage(FtpSyncWorker.class, (String)"FTP_Err_Unzip", (Object)remoteFile, (Object)this.executionEnvironment, (Object)status.exitCode));
                }
                for (FileCollector.FileCollectorInfo fileInfo : toCopy) {
                    this.fileData.setState(fileInfo.file, FileState.COPIED);
                }
                if (zipFile != null && zipFile.exists() && !zipFile.delete()) {
                    RemoteUtil.LOGGER.log(Level.INFO, "Can not delete temporary file {0}", zipFile.getAbsolutePath());
                }
                if (remoteFile == null) break block22;
            }
            catch (Throwable throwable) {
                if (zipFile != null && zipFile.exists() && !zipFile.delete()) {
                    RemoteUtil.LOGGER.log(Level.INFO, "Can not delete temporary file {0}", zipFile.getAbsolutePath());
                }
                if (remoteFile != null) {
                    CommonTasksSupport.rmFile((ExecutionEnvironment)this.executionEnvironment, remoteFile, null);
                }
                throw throwable;
            }
            CommonTasksSupport.rmFile((ExecutionEnvironment)this.executionEnvironment, (String)remoteFile, null);
        }
        this.progressHandle.progress(this.uploadCount += toCopy.size() / 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startup(Map<String, String> env2add) {
        if (SyncUtils.isDoubleRemote(this.executionEnvironment, this.fileSystem)) {
            RemoteSyncNotifier.getInstance().warnDoubleRemote(this.executionEnvironment, this.fileSystem);
            return false;
        }
        String remoteRoot = RemotePathMap.getRemoteSyncRoot(this.executionEnvironment);
        if (remoteRoot == null) {
            if (this.err != null) {
                this.err.printf("%s%n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
            }
            return false;
        }
        boolean success = false;
        this.thread = Thread.currentThread();
        this.cancelled = false;
        String title = "Uploading to " + ServerList.get((ExecutionEnvironment)this.executionEnvironment).getDisplayName();
        this.progressHandle = ProgressHandle.createHandle((String)title, (Cancellable)this);
        this.progressHandle.start();
        try {
            if (this.out != null) {
                this.out.printf("%s%n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
            }
            this.synchronizeImpl(remoteRoot);
            boolean bl = success = !this.cancelled;
            if (success) {
                this.fileData.store();
            }
        }
        catch (InterruptedException ex) {
            RemoteUtil.LOGGER.finest(ex.getMessage());
        }
        catch (InterruptedIOException ex) {
            RemoteUtil.LOGGER.finest(ex.getMessage());
        }
        catch (ExecutionException ex) {
            RemoteUtil.LOGGER.log(Level.FINE, null, ex);
            if (this.err != null) {
                this.err.printf("%s%n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
            }
        }
        catch (IOException ex) {
            RemoteUtil.LOGGER.log(Level.FINE, null, ex);
            if (this.err != null) {
                this.err.printf("%s%n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
            }
        }
        catch (ConnectionManager.CancellationException ex) {
            this.cancelled = true;
        }
        finally {
            this.cancelled = false;
            this.thread = null;
            this.progressHandle.finish();
        }
        return success;
    }

    public void shutdown() {
        try {
            this.fileCollector.runNewFilesDiscovery(true);
            this.fileCollector.shutDownNewFilesDiscovery();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (InterruptedException | ConnectionManager.CancellationException throwable) {
            // empty catch block
        }
    }

    public boolean cancel() {
        this.cancelled = true;
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
        return true;
    }

    private static File getTemp() {
        String tmpPath = System.getProperty("java.io.tmpdir");
        File tmpFile = CndFileUtils.createLocalFile((String)tmpPath);
        return tmpFile.exists() ? tmpFile : null;
    }

    private static final class ZipIOException
    extends IOException {
        private ZipIOException(String message) {
            super(message);
        }
    }

    private static interface LineProcessor {
        public void processLine(String var1);
    }

    private static interface Feeder {
        public void feed(BufferedWriter var1) throws IOException;
    }
}

