/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.assistance;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.asm.core.assistance.LiveRangesAccessor;
import org.netbeans.modules.cnd.asm.model.AsmState;
import org.netbeans.modules.cnd.asm.model.lang.AsmElement;
import org.netbeans.modules.cnd.asm.model.lang.InstructionElement;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.netbeans.modules.cnd.asm.model.lang.syntax.FunctionBoundsResolver;
import org.netbeans.modules.cnd.asm.model.util.AsmModelUtilities;
import org.netbeans.modules.cnd.asm.model.util.IntervalSet;

public class LiveRangesAction {
    public LiveRangesAccessor calculateRanges(AsmState state) {
        AsmElement comp = state.getElements();
        FunctionBoundsResolver resolver = (FunctionBoundsResolver)state.getServices().lookup(FunctionBoundsResolver.class);
        if (resolver == null) {
            return null;
        }
        IntervalSet<FunctionBoundsResolver.Entry> funcs = resolver.getFunctions();
        LivaRangesAccessorImpl res = new LivaRangesAccessorImpl(state);
        for (FunctionBoundsResolver.Entry en : funcs) {
            this.calculateRanges(comp, res, en.getStartOffset(), en.getEndOffset());
        }
        return res;
    }

    private void calculateRanges(AsmElement root, LivaRangesAccessorImpl res, int start, int end) {
        Integer lw;
        Integer lr;
        Register reg;
        List<AsmElement> comp = root.getCompounds();
        HashMap<Register, Integer> lastWrite = new HashMap<Register, Integer>();
        HashMap<Register, Integer> lastRead = new HashMap<Register, Integer>();
        for (int cur = start; cur < end; ++cur) {
            AsmElement c = comp.get(cur);
            if (!(c instanceof InstructionElement)) continue;
            InstructionElement instr = (InstructionElement)c;
            Collection<Register> readed = AsmModelUtilities.getRegistersClosure(instr.getReadRegs());
            Collection<Register> writed = AsmModelUtilities.getRegistersClosure(instr.getWriteRegs());
            for (Register reg2 : readed) {
                lastRead.put(reg2, cur);
            }
            for (Register reg2 : writed) {
                Integer lw2 = (Integer)lastWrite.get(reg2);
                Integer lr2 = (Integer)lastRead.get(reg2);
                if (lw2 == null && lr2 != null) {
                    res.addRange(reg2, start, lr2);
                } else if (lw2 != null && lr2 != null && lr2 > lw2) {
                    res.addRange(reg2, lw2, lr2);
                }
                lastWrite.put(reg2, cur);
            }
        }
        for (Map.Entry entry : lastWrite.entrySet()) {
            reg = (Register)entry.getKey();
            lr = (Integer)lastRead.get(reg);
            lw = (Integer)entry.getValue();
            if (lw == null || lr != null && lr >= lw) continue;
            res.addRange(reg, lw, end - 1);
        }
        for (Map.Entry entry : lastRead.entrySet()) {
            reg = (Register)entry.getKey();
            lr = (Integer)entry.getValue();
            lw = (Integer)lastWrite.get(reg);
            if (lw == null && lr != null) {
                res.addRange(reg, start, lr);
                continue;
            }
            if (lw == null || lr == null || lr <= lw) continue;
            res.addRange(reg, lw, lr);
        }
    }

    private static class LivaRangesAccessorImpl
    implements LiveRangesAccessor {
        private final Map<Register, List<Integer>> ranges;
        private final AsmState state;

        public LivaRangesAccessorImpl(AsmState state) {
            this.state = state;
            this.ranges = new HashMap<Register, List<Integer>>();
        }

        public void addRange(Register reg, int start, int end) {
            List<Integer> rangesReg = this.ranges.get(reg);
            if (rangesReg == null) {
                rangesReg = new LinkedList<Integer>();
                this.ranges.put(reg, rangesReg);
            }
            rangesReg.add(start);
            rangesReg.add(end);
        }

        @Override
        public AsmState getState() {
            return this.state;
        }

        @Override
        public List<Integer> getRangesForRegister(Register reg) {
            List<Integer> rangesReg = this.ranges.get(reg);
            if (rangesReg == null || rangesReg.size() == 0) {
                return Collections.emptyList();
            }
            return rangesReg;
        }
    }
}

