/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.testbench;

import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;

public class BaseStatistics<K extends Comparable<?>> {
    protected int min = 0;
    protected int max = 0;
    protected int cnt = 0;
    protected int sum;
    protected String text;
    protected final Map<K, Integer> values = new TreeMap<K, Integer>();
    protected int level;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_MINUMUN = 1;
    public static final int LEVEL_MEDIUM = 2;
    public static final int LEVEL_MAXIMUM = 3;

    public BaseStatistics(String text, int level) {
        this.text = text;
        this.level = level;
    }

    public void consume(K key, int value) {
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
        ++this.cnt;
        this.sum += value;
        if (this.values != null) {
            Integer count = this.values.get(key);
            this.values.put(key, count == null ? 1 : count + 1);
        }
    }

    public void print(PrintStream ps) {
        int avg = this.cnt == 0 ? 0 : this.sum / this.cnt;
        ps.printf("%s %8d min    %8d max    %8d avg    %8d cnt    %8d sum\n", this.text, this.min, this.max, avg, this.cnt, this.sum);
        if (this.values != null) {
            this.printDistribution(ps);
        }
    }

    protected void printDistributionDetailed(PrintStream ps) {
        int maxKeyLen = 0;
        String alignment = "-";
        for (Map.Entry<K, Integer> entry : this.values.entrySet()) {
            int currKeyLen;
            Comparable key = (Comparable)entry.getKey();
            if (key == null) {
                currKeyLen = 4;
            } else {
                if (key instanceof Number) {
                    maxKeyLen = 8;
                    alignment = "";
                    break;
                }
                currKeyLen = key.toString().length();
            }
            if (currKeyLen <= maxKeyLen) continue;
            maxKeyLen = currKeyLen;
        }
        String format = "\t%" + alignment + maxKeyLen + "s %8d\n";
        for (Map.Entry<K, Integer> entry : this.values.entrySet()) {
            ps.printf(format, entry.getKey(), entry.getValue());
        }
    }

    protected void printDistribution(PrintStream ps) {
        ps.printf("\tDistribution:\n", new Object[0]);
        this.printDistributionDetailed(ps);
    }

    public void clear() {
        this.sum = 0;
        this.cnt = 0;
        this.max = 0;
        this.min = 0;
        this.values.clear();
    }
}

