/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class JavadocForBinaryQueryLibraryImpl
implements JavadocForBinaryQueryImplementation {
    private final Map<URI, URL> normalizedURLCache = new ConcurrentHashMap<URI, URL>();

    @CheckForNull
    public JavadocForBinaryQuery.Result findJavadoc(@NonNull URL b) {
        Boolean isNormalizedURL = JavadocForBinaryQueryLibraryImpl.isNormalizedURL(b);
        if (isNormalizedURL != null) {
            for (LibraryManager mgr : LibraryManager.getOpenManagers()) {
                for (Library lib : mgr.getLibraries()) {
                    if (!lib.getType().equals("j2se")) continue;
                    for (URL entry : lib.getContent("classpath")) {
                        URL normalizedEntry = isNormalizedURL == Boolean.TRUE ? this.getNormalizedURL(entry) : entry;
                        if (!b.equals(normalizedEntry)) continue;
                        return new R(lib);
                    }
                }
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL url) {
        FileObject fo;
        URL normalizedURL;
        Boolean isNormalized = JavadocForBinaryQueryLibraryImpl.isNormalizedURL(url);
        if (isNormalized == null) {
            return null;
        }
        if (isNormalized == Boolean.TRUE) {
            return url;
        }
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        URL uRL = normalizedURL = uri == null ? null : this.normalizedURLCache.get(uri);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            normalizedURL = fo.toURL();
            if (uri != null) {
                this.normalizedURLCache.put(uri, normalizedURL);
            }
        }
        return normalizedURL;
    }

    private static Boolean isNormalizedURL(URL url) {
        if ("jar".equals(url.getProtocol()) && (url = FileUtil.getArchiveFile((URL)url)) == null) {
            return null;
        }
        return "file".equals(url.getProtocol());
    }

    private static class R
    implements JavadocForBinaryQuery.Result,
    PropertyChangeListener {
        private final Library lib;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private URL[] cachedRoots;

        public R(Library lib) {
            this.lib = lib;
            this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
        }

        public synchronized URL[] getRoots() {
            if (this.cachedRoots == null) {
                ArrayList<URL> result = new ArrayList<URL>();
                for (URL u : this.lib.getContent("javadoc")) {
                    result.add(R.getIndexFolder(u));
                }
                this.cachedRoots = result.toArray(new URL[result.size()]);
            }
            return this.cachedRoots;
        }

        public void addChangeListener(ChangeListener l) {
            assert (l != null) : "Listener can not be null";
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            assert (l != null) : "Listener can not be null";
            this.cs.removeChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("content".equals(event.getPropertyName())) {
                R r = this;
                synchronized (r) {
                    this.cachedRoots = null;
                }
                this.cs.fireChange();
            }
        }

        private static URL getIndexFolder(URL url) {
            assert (url != null);
            FileObject root = URLMapper.findFileObject((URL)url);
            if (root == null) {
                return url;
            }
            FileObject index = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)root);
            if (index == null) {
                return url;
            }
            return index.toURL();
        }
    }
}

