/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.spi;

import java.util.Map;
import java.util.Set;

public final class DotClassPathEntry {
    public static final String ATTRIBUTE_KIND = "kind";
    public static final String ATTRIBUTE_PATH = "path";
    public static final String ATTRIBUTE_EXPORTED = "exported";
    public static final String ATTRIBUTE_SOURCEPATH = "sourcepath";
    public static final String ATTRIBUTE_JAVADOC = "javadoc_location";
    public static final String ATTRIBUTE_SOURCE_EXCLUDES = "excluding";
    public static final String ATTRIBUTE_SOURCE_INCLUDES = "including";
    private Map<String, String> properties;
    private String absolutePath;
    private String containerMapping;
    private String linkName;
    private Boolean importSuccessful;

    public DotClassPathEntry(Map<String, String> properties, String linkName) {
        this.properties = properties;
        this.linkName = linkName;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Kind getKind() {
        String value = this.getProperty(ATTRIBUTE_KIND);
        if ("con".equals(value)) {
            return Kind.CONTAINER;
        }
        if ("lib".equals(value)) {
            return Kind.LIBRARY;
        }
        if ("src".equals(value)) {
            if (this.getRawPath().startsWith("/") && this.getLinkName() == null) {
                return Kind.PROJECT;
            }
            return Kind.SOURCE;
        }
        if ("var".equals(value)) {
            return Kind.VARIABLE;
        }
        if ("output".equals(value)) {
            return Kind.OUTPUT;
        }
        throw new IllegalStateException("unknown kind: " + value);
    }

    public String getRawPath() {
        return this.getProperty(ATTRIBUTE_PATH);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    String getLinkName() {
        return this.linkName;
    }

    public boolean isExported() {
        return Boolean.parseBoolean(this.getProperty(ATTRIBUTE_EXPORTED));
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String toString() {
        return "DotClassPathEntry: " + this.properties;
    }

    public String getContainerMapping() {
        return this.containerMapping;
    }

    public void setContainerMapping(String containerMapping) {
        this.containerMapping = containerMapping;
    }

    public Boolean getImportSuccessful() {
        return this.importSuccessful;
    }

    public void setImportSuccessful(Boolean importSuccessful) {
        this.importSuccessful = importSuccessful;
    }

    public void updateVariableValue(String value) {
        this.properties.put(ATTRIBUTE_PATH, value);
    }

    public void updateSourcePath(String value) {
        this.properties.put(ATTRIBUTE_SOURCEPATH, value);
    }

    public void updateJavadoc(String value) {
        if (value == null) {
            this.properties.remove(ATTRIBUTE_JAVADOC);
        } else {
            this.properties.put(ATTRIBUTE_JAVADOC, value);
        }
    }

    public static enum Kind {
        CONTAINER,
        LIBRARY,
        PROJECT,
        SOURCE,
        VARIABLE,
        OUTPUT;

    }
}

