/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmCacheMap;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFriendResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.ClassifiersAntiLoop;
import org.netbeans.modules.cnd.utils.Antiloop;

public final class CsmInheritanceUtilities {
    private static final ThreadLocal<Antiloop<CsmInheritance>> threadLocalInheritanceAntiloop = new ThreadLocal<Antiloop<CsmInheritance>>(){

        @Override
        protected Antiloop<CsmInheritance> initialValue() {
            return new Antiloop();
        }
    };
    private static final int PRIVATE = 1;
    private static final int PROTECTED = 2;
    private static final int PUBLIC = 4;
    private static final int NONE = 8;
    public static final CsmVisibility MAX_VISIBILITY = CsmVisibility.PRIVATE;
    private static final Logger LOG = Logger.getLogger(CsmInheritanceUtilities.class.getSimpleName());
    private static final Callable<CsmCacheMap> INHERITANCE_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("INHERITANCE Cache", 1);
        }
    };

    private CsmInheritanceUtilities() {
    }

    private static int visToInt(CsmVisibility vis) {
        if (vis == CsmVisibility.NONE) {
            return 8;
        }
        if (vis == CsmVisibility.PRIVATE) {
            return 1;
        }
        if (vis == CsmVisibility.PROTECTED) {
            return 2;
        }
        assert (vis == CsmVisibility.PUBLIC);
        return 4;
    }

    private static CsmVisibility intToVis(int visInt) {
        switch (visInt) {
            case 8: {
                return CsmVisibility.NONE;
            }
            case 1: {
                return CsmVisibility.PRIVATE;
            }
            case 2: {
                return CsmVisibility.PROTECTED;
            }
        }
        assert (visInt == 4);
        return CsmVisibility.PUBLIC;
    }

    public static boolean matchVisibility(CsmMember member, CsmVisibility minVisibility) {
        assert (member.getVisibility() != null) : "can't be null visibility";
        return CsmInheritanceUtilities.matchVisibility(member.getVisibility(), minVisibility);
    }

    private static boolean matchVisibility(CsmVisibility toCheck, CsmVisibility minVisibility) {
        assert (toCheck != null && minVisibility != null);
        if (minVisibility == CsmVisibility.NONE) {
            return false;
        }
        int memberVis = CsmInheritanceUtilities.visToInt(toCheck);
        int minVis = CsmInheritanceUtilities.visToInt(minVisibility);
        return minVis <= memberVis;
    }

    private static CsmVisibility getInheritanceVisibility(CsmVisibility inheritBA) {
        return CsmVisibility.PROTECTED;
    }

    private static CsmVisibility getExtInheritanceVisibility(CsmVisibility inheritBA) {
        if (inheritBA == CsmVisibility.PUBLIC) {
            return CsmVisibility.PUBLIC;
        }
        return CsmVisibility.NONE;
    }

    private static CsmVisibility getChildInheritanceVisibility(CsmVisibility inheritBA) {
        if (inheritBA == CsmVisibility.PUBLIC || inheritBA == CsmVisibility.PROTECTED) {
            return CsmVisibility.PROTECTED;
        }
        return CsmVisibility.NONE;
    }

    public static CsmVisibility mergeInheritedVisibility(CsmVisibility curVisibility, CsmVisibility inherVisibility) {
        return CsmInheritanceUtilities.getMinVisibility(curVisibility, CsmInheritanceUtilities.getInheritanceVisibility(inherVisibility));
    }

    public static CsmVisibility mergeExtInheritedVisibility(CsmVisibility curVisibility, CsmVisibility inherVisibility) {
        return CsmInheritanceUtilities.getMinVisibility(curVisibility, CsmInheritanceUtilities.getExtInheritanceVisibility(inherVisibility));
    }

    public static CsmVisibility mergeChildInheritanceVisibility(CsmVisibility curVisibility, CsmVisibility inheritBA) {
        return CsmInheritanceUtilities.getMinVisibility(curVisibility, CsmInheritanceUtilities.getChildInheritanceVisibility(inheritBA));
    }

    private static CsmVisibility getMinVisibility(CsmVisibility vis1, CsmVisibility vis2) {
        assert (vis1 != null && vis2 != null);
        int visInt1 = CsmInheritanceUtilities.visToInt(vis1);
        int visInt2 = CsmInheritanceUtilities.visToInt(vis2);
        int newMinVis = Math.max(visInt1, visInt2);
        return CsmInheritanceUtilities.intToVis(newMinVis);
    }

    private static CsmVisibility getMaxVisibility(CsmVisibility vis1, CsmVisibility vis2) {
        assert (vis1 != null && vis2 != null);
        int visInt1 = CsmInheritanceUtilities.visToInt(vis1);
        int visInt2 = CsmInheritanceUtilities.visToInt(vis2);
        int newMaxVis = Math.min(visInt1, visInt2);
        return CsmInheritanceUtilities.intToVis(newMaxVis);
    }

    public static CsmVisibility getContextVisibility(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration) {
        return CsmInheritanceUtilities.getContextVisibility(clazz, contextDeclaration, CsmVisibility.PUBLIC, false);
    }

    public static CsmVisibility getContextVisibility(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, CsmVisibility defVisibilityValue, boolean checkInheritance) {
        return CsmInheritanceUtilities.getContextVisibilityInfo((CsmClass)clazz, (CsmOffsetableDeclaration)contextDeclaration, (CsmVisibility)defVisibilityValue, (boolean)checkInheritance).visibility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextVisibilityInfo getContextVisibilityInfo(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, CsmVisibility defVisibilityValue, boolean checkInheritance) {
        ContextVisibilityInfo contextVisibilityInfo;
        block21: {
            long time;
            block19: {
                ContextVisibilityInfo contextVisibilityInfo2;
                block20: {
                    CsmClass contextClass;
                    block17: {
                        ContextVisibilityInfo contextVisibilityInfo3;
                        block18: {
                            block15: {
                                ContextVisibilityInfo contextVisibilityInfo4;
                                block16: {
                                    block13: {
                                        ContextVisibilityInfo contextVisibilityInfo5;
                                        block14: {
                                            block11: {
                                                ContextVisibilityInfo contextVisibilityInfo6;
                                                block12: {
                                                    assert (clazz != null);
                                                    time = System.currentTimeMillis();
                                                    contextClass = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)contextDeclaration);
                                                    if (!CsmInheritanceUtilities.areEqualClasses(clazz, contextClass)) break block11;
                                                    contextVisibilityInfo6 = new ContextVisibilityInfo(MAX_VISIBILITY, false);
                                                    if (!LOG.isLoggable(Level.FINE)) break block12;
                                                    time = System.currentTimeMillis() - time;
                                                    LOG.log(Level.FINE, "getContextVisibilityInfo took {0}ms\n", new Object[]{time});
                                                }
                                                return contextVisibilityInfo6;
                                            }
                                            if (!CsmFriendResolver.getDefault().isFriend(contextDeclaration, clazz)) break block13;
                                            contextVisibilityInfo5 = new ContextVisibilityInfo(MAX_VISIBILITY, true);
                                            if (!LOG.isLoggable(Level.FINE)) break block14;
                                            time = System.currentTimeMillis() - time;
                                            LOG.log(Level.FINE, "getContextVisibilityInfo took {0}ms\n", new Object[]{time});
                                        }
                                        return contextVisibilityInfo5;
                                    }
                                    if (!CsmInheritanceUtilities.isNestedClass(contextClass, clazz)) break block15;
                                    contextVisibilityInfo4 = new ContextVisibilityInfo(MAX_VISIBILITY, false);
                                    if (!LOG.isLoggable(Level.FINE)) break block16;
                                    time = System.currentTimeMillis() - time;
                                    LOG.log(Level.FINE, "getContextVisibilityInfo took {0}ms\n", new Object[]{time});
                                }
                                return contextVisibilityInfo4;
                            }
                            if (contextClass != null && checkInheritance) break block17;
                            contextVisibilityInfo3 = new ContextVisibilityInfo(defVisibilityValue, false);
                            if (!LOG.isLoggable(Level.FINE)) break block18;
                            time = System.currentTimeMillis() - time;
                            LOG.log(Level.FINE, "getContextVisibilityInfo took {0}ms\n", new Object[]{time});
                        }
                        return contextVisibilityInfo3;
                    }
                    try {
                        List<CsmInheritance> chain = CsmInheritanceUtilities.findInheritanceChain(contextClass, clazz);
                        if (chain == null) break block19;
                        assert (chain.size() > 0);
                        CsmVisibility mergedVisibility = CsmVisibility.PROTECTED;
                        for (int i = 0; i < chain.size(); ++i) {
                            CsmInheritance inherit = chain.get(i);
                            mergedVisibility = i == 0 ? CsmInheritanceUtilities.mergeInheritedVisibility(mergedVisibility, inherit.getVisibility()) : CsmInheritanceUtilities.mergeChildInheritanceVisibility(mergedVisibility, inherit.getVisibility());
                        }
                        contextVisibilityInfo2 = new ContextVisibilityInfo(mergedVisibility, false);
                        if (!LOG.isLoggable(Level.FINE)) break block20;
                    }
                    catch (Throwable throwable) {
                        if (LOG.isLoggable(Level.FINE)) {
                            time = System.currentTimeMillis() - time;
                            LOG.log(Level.FINE, "getContextVisibilityInfo took {0}ms\n", new Object[]{time});
                        }
                        throw throwable;
                    }
                    time = System.currentTimeMillis() - time;
                    LOG.log(Level.FINE, "getContextVisibilityInfo took {0}ms\n", new Object[]{time});
                }
                return contextVisibilityInfo2;
            }
            contextVisibilityInfo = new ContextVisibilityInfo(defVisibilityValue, false);
            if (!LOG.isLoggable(Level.FINE)) break block21;
            time = System.currentTimeMillis() - time;
            LOG.log(Level.FINE, "getContextVisibilityInfo took {0}ms\n", new Object[]{time});
        }
        return contextVisibilityInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CsmInheritance> findInheritanceChain(CsmClass child, CsmClass parent) {
        ArrayList<CsmInheritance> arrayList;
        block8: {
            if (child == null || parent == null) {
                return null;
            }
            long time = System.currentTimeMillis();
            try {
                CsmCacheMap cache = CsmCacheManager.getClientCache(InheritanceChainKey.class, INHERITANCE_INITIALIZER);
                InheritanceChainKey key = new InheritanceChainKey(child, parent);
                List<Object> res = (ArrayList<CsmInheritance>)CsmCacheMap.getFromCache(cache, key, null);
                if (res == null) {
                    long resolveTime = System.currentTimeMillis();
                    res = new ArrayList<CsmInheritance>();
                    ClassifiersAntiLoop handledClasses = new ClassifiersAntiLoop();
                    if (!CsmInheritanceUtilities.findInheritanceChain(child, parent, res, handledClasses)) {
                        res = Collections.emptyList();
                    }
                    resolveTime = System.currentTimeMillis() - resolveTime;
                    if (cache != null) {
                        cache.put(key, CsmCacheMap.toValue(res, resolveTime));
                    }
                }
                if (res.isEmpty()) {
                    res = null;
                }
                arrayList = res;
                if (!LOG.isLoggable(Level.FINE)) break block8;
            }
            catch (Throwable throwable) {
                if (LOG.isLoggable(Level.FINE)) {
                    time = System.currentTimeMillis() - time;
                    LOG.log(Level.FINE, "findInheritanceChain took {0}ms:\n\tchild={1}\n\tparent={2}\n", new Object[]{time, CsmInheritanceUtilities.getPosition(child), CsmInheritanceUtilities.getPosition(parent)});
                }
                throw throwable;
            }
            time = System.currentTimeMillis() - time;
            LOG.log(Level.FINE, "findInheritanceChain took {0}ms:\n\tchild={1}\n\tparent={2}\n", new Object[]{time, CsmInheritanceUtilities.getPosition(child), CsmInheritanceUtilities.getPosition(parent)});
        }
        return arrayList;
    }

    public static boolean isAssignableFrom(CsmClass child, CsmClass parent) {
        CsmInstantiation parentInstantiation;
        CsmOffsetableDeclaration parentTemplateDeclaration;
        Collection<CsmOffsetableDeclaration> baseTemplates;
        assert (parent != null);
        if (CsmInheritanceUtilities.areEqualClasses(parent, child)) {
            return true;
        }
        if (CsmKindUtilities.isTemplate((CsmObject)child) && CsmKindUtilities.isTemplateInstantiation((CsmObject)parent) && (baseTemplates = CsmInstantiationProvider.getDefault().getBaseTemplate((CsmDeclaration)child)).contains(parentTemplateDeclaration = (parentInstantiation = (CsmInstantiation)parent).getTemplateDeclaration())) {
            return true;
        }
        List<CsmInheritance> chain = CsmInheritanceUtilities.findInheritanceChain(child, parent);
        return chain != null;
    }

    private static boolean findInheritanceChain(CsmClass child, CsmClass parent, List<CsmInheritance> res, ClassifiersAntiLoop handledClasses) {
        if (child == null || !handledClasses.add((CsmClassifier)child)) {
            return false;
        }
        Collection base = child.getBaseClasses();
        if (base == null || base.size() == 0) {
            return false;
        }
        CsmInheritance inh = CsmInheritanceUtilities.findDirectInheritance(child, parent);
        if (inh != null) {
            res.add(inh);
            return true;
        }
        ArrayList<CsmInheritance> bestChain = null;
        CsmInheritance bestInh = null;
        for (CsmInheritance curInh : base) {
            ArrayList<CsmInheritance> curInhRes = new ArrayList<CsmInheritance>();
            if (!CsmInheritanceUtilities.findInheritanceChain(CsmInheritanceUtilities.getCsmClass(curInh), parent, curInhRes, handledClasses)) continue;
            bestChain = curInhRes;
            bestInh = curInh;
            break;
        }
        if (bestChain != null) {
            assert (bestChain.size() > 0);
            res.add(bestInh);
            res.addAll((Collection<CsmInheritance>)bestChain);
            return true;
        }
        return false;
    }

    public static CsmClass getCsmClass(CsmInheritance inh) {
        CsmClass out = null;
        if (threadLocalInheritanceAntiloop.get().enter((Object)inh)) {
            try {
                CsmClassifier classifier = inh.getClassifier();
                classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)classifier, (CsmFile)inh.getContainingFile());
                if (CsmKindUtilities.isClass((CsmObject)classifier)) {
                    out = (CsmClass)classifier;
                }
            }
            finally {
                threadLocalInheritanceAntiloop.get().exit((Object)inh);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getCsmClass for\n{0}\n=>getCsmClass=>\n{1}", new Object[]{inh, out});
        }
        return out;
    }

    private static CsmInheritance findDirectInheritance(CsmClass child, CsmClass parent) {
        assert (parent != null);
        Collection base = child.getBaseClasses();
        if (base != null && base.size() > 0) {
            for (CsmInheritance curInh : base) {
                if (!CsmInheritanceUtilities.areEqualClasses(parent, CsmInheritanceUtilities.getCsmClass(curInh))) continue;
                return curInh;
            }
        }
        return null;
    }

    private static boolean areEqualClasses(CsmClass clazz, CsmClass contextClass) {
        assert (clazz != null);
        if (clazz.equals(contextClass)) {
            return true;
        }
        if (contextClass != null && (CsmKindUtilities.isTemplate((CsmObject)clazz) || CsmKindUtilities.isTemplateInstantiation((CsmObject)clazz))) {
            return clazz.getUniqueName().equals(contextClass.getUniqueName());
        }
        return false;
    }

    private static boolean isNestedClass(CsmClass inner, CsmClass outer) {
        return inner != null && outer != null && CharSequenceUtilities.startsWith((CharSequence)inner.getQualifiedName(), (CharSequence)outer.getQualifiedName());
    }

    private static CharSequence getPosition(CsmClass obj) {
        CsmFile file = obj.getContainingFile();
        String position = file.getAbsolutePath().toString();
        int[] lineColumn = CsmFileInfoQuery.getDefault().getLineColumnByOffset(file, obj.getStartOffset());
        if (lineColumn != null) {
            position = "line=" + lineColumn[0] + ":" + lineColumn[1] + " " + position;
        }
        return position;
    }

    private static final class InheritanceChainKey {
        private final CsmClass child;
        private final CsmClass parent;

        public InheritanceChainKey(CsmClass child, CsmClass parent) {
            this.child = child;
            this.parent = parent;
        }

        public int hashCode() {
            int hash = 5;
            hash = 61 * hash + this.child.hashCode();
            hash = 61 * hash + this.parent.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InheritanceChainKey other = (InheritanceChainKey)obj;
            if (!this.child.equals(other.child)) {
                return false;
            }
            return this.parent.equals(other.parent);
        }
    }

    public static final class ContextVisibilityInfo {
        public final CsmVisibility visibility;
        public final boolean friend;

        public ContextVisibilityInfo(CsmVisibility visibility, boolean friend) {
            this.visibility = visibility;
            this.friend = friend;
        }
    }
}

