/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.openide.util.Lookup;

public abstract class CsmUsingResolver {
    private static final CsmUsingResolver EMPTY = new Empty();
    private static CsmUsingResolver defaultResolver;

    protected CsmUsingResolver() {
    }

    public static CsmUsingResolver getDefault() {
        if (defaultResolver != null) {
            return defaultResolver;
        }
        defaultResolver = (CsmUsingResolver)Lookup.getDefault().lookup(CsmUsingResolver.class);
        return defaultResolver == null ? EMPTY : defaultResolver;
    }

    public abstract Collection<CsmDeclaration> findUsedDeclarations(CsmFile var1, int var2, CsmProject var3);

    public abstract Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace var1);

    public abstract Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace var1, CharSequence var2);

    public abstract Collection<CsmNamespace> findVisibleNamespaces(CsmFile var1, int var2, CsmProject var3);

    public abstract Collection<CsmUsingDirective> findUsingDirectives(CsmNamespace var1);

    public abstract Collection<CsmNamespace> findVisibleNamespaces(CsmNamespace var1, CsmProject var2);

    public abstract Collection<CsmNamespaceAlias> findNamespaceAliases(CsmFile var1, int var2, CsmProject var3);

    public abstract Collection<CsmNamespaceAlias> findNamespaceAliases(CsmNamespace var1);

    private static final class Empty
    extends CsmUsingResolver {
        Empty() {
        }

        @Override
        public Collection<CsmDeclaration> findUsedDeclarations(CsmFile file, int offset, CsmProject onlyInProject) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace namespace) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace namespace, CharSequence name) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmUsingDirective> findUsingDirectives(CsmNamespace namespace) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespace> findVisibleNamespaces(CsmFile file, int offset, CsmProject onlyInProject) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespaceAlias> findNamespaceAliases(CsmFile file, int offset, CsmProject onlyInProject) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespaceAlias> findNamespaceAliases(CsmNamespace ns) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespace> findVisibleNamespaces(CsmNamespace namespace, CsmProject prj) {
            return Collections.emptyList();
        }
    }
}

