/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.ByteBufferInputStream;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLUtils;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLWorkerThread;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SSLByteBufferInputStream
extends ByteBufferInputStream {
    protected int doRead() {
        SSLWorkerThread workerThread = (SSLWorkerThread)Thread.currentThread();
        this.byteBuffer.compact();
        int initialPosition = this.byteBuffer.position();
        int byteRead = 0;
        while (this.byteBuffer.position() == initialPosition) {
            int currentRead = SSLUtils.doRead(this.key, workerThread.getInputBB(), workerThread.getSSLEngine(), this.readTimeout);
            if (currentRead > 0) {
                byteRead += currentRead;
            }
            if (currentRead > 0 || workerThread.getInputBB().position() > 0) {
                try {
                    this.byteBuffer = SSLUtils.unwrapAll(this.byteBuffer, workerThread.getInputBB(), workerThread.getSSLEngine());
                    workerThread.setByteBuffer(this.byteBuffer);
                    if (currentRead != -1 || this.byteBuffer.position() != initialPosition) continue;
                    byteRead = -1;
                    break;
                }
                catch (IOException ex) {
                    Logger logger = SSLSelectorThread.logger();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLUtils.unwrapAll", ex);
                    }
                    return -1;
                }
            }
            if (currentRead != -1) break;
            byteRead = -1;
            break;
        }
        this.byteBuffer.flip();
        return byteRead;
    }
}

