/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.runprofiles;

import org.netbeans.modules.cnd.api.picklist.PicklistElement;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.xml.sax.Attributes;

public class RunProfileXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private final RunProfile profile;
    private static final String PROFILE_ID = "runprofile";
    private static final String VARIABLE_ELEMENT = "variable";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String ENVIRONMENT_ELEMENT = "environment";
    private static final String ARGS_ELEMENT = "args";
    private static final String ARGUMENTS_ELEMENT = "arguments";
    private static final String RUNDIR_ELEMENT = "rundir";
    private static final String RUNCOMMAND_ELEMENT = "runcommand";
    private static final String RUNCOMMAND_PICKLIST_ELEMENT = "runcommandpicklist";
    private static final String RUNCOMMAND_PICKLIST_ITEM_ELEMENT = "runcommandpicklistitem";
    private static final String BUILD_FIRST_ELEMENT = "buildfirst";
    private static final String CONSOLE_TYPE_ELEMENT = "console-type";
    private static final String TERMINAL_TYPE_ELEMENT = "terminal-type";
    private static final String REMOVE_INSTRUMENTATION_ELEMENT = "remove-instrumentation";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    private static final int thisversion = 9;

    public RunProfileXMLCodec(RunProfile profile) {
        this.profile = profile;
    }

    public static int getVersion() {
        return 9;
    }

    public String tag() {
        return PROFILE_ID;
    }

    public void start(Attributes atts) throws VersionException {
        String what = "run profile";
        int maxVersion = RunProfileXMLCodec.getVersion();
        this.checkVersion(atts, what, maxVersion);
    }

    public void end() {
        this.profile.clearChanged();
    }

    public void startElement(String element, Attributes atts) {
        if (element.equals(VARIABLE_ELEMENT)) {
            this.profile.getEnvironment().putenv(atts.getValue(NAME_ATTR), atts.getValue(VALUE_ATTR));
        } else if (element.equals(RUNCOMMAND_PICKLIST_ELEMENT)) {
            // empty if block
        }
    }

    public void endElement(String element, String currentText) {
        if (element.equals(ARGS_ELEMENT)) {
            this.profile.setArgsRaw(currentText);
        } else if (element.equals(RUNDIR_ELEMENT)) {
            this.profile.setRunDir(currentText);
        } else if (element.equals(ARGUMENTS_ELEMENT)) {
            this.profile.getConfigurationArguments().setValue(currentText);
        } else if (element.equals(RUNCOMMAND_ELEMENT)) {
            this.profile.getRunCommand().setValue(currentText);
            this.profile.getRunCommand().getPicklist().addElement(currentText);
        } else if (element.equals(BUILD_FIRST_ELEMENT)) {
            this.profile.setBuildFirst(currentText.equals(TRUE_VALUE));
        } else if (element.equals(RUNCOMMAND_PICKLIST_ITEM_ELEMENT)) {
            this.profile.getRunCommand().getPicklist().addElement(currentText);
        } else {
            int idx;
            try {
                idx = Integer.parseInt(currentText);
            }
            catch (NumberFormatException ex) {
                idx = 0;
            }
            if (element.equals(CONSOLE_TYPE_ELEMENT)) {
                if (idx == 0) {
                    idx = RunProfile.getDefaultConsoleType();
                }
                this.profile.getConsoleType().setValue(idx);
            } else if (element.equals(TERMINAL_TYPE_ELEMENT)) {
                this.profile.getTerminalType().setValue(idx);
            } else if (element.equals(REMOVE_INSTRUMENTATION_ELEMENT)) {
                this.profile.getRemoveInstrumentation().setValue(idx);
            }
        }
    }

    private static void encode(XMLEncoderStream xes, String[] pair) {
        xes.element(VARIABLE_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + pair[0]), new AttrValuePair(VALUE_ATTR, "" + pair[1])});
    }

    private static void encode(XMLEncoderStream xes, Env env) {
        String[][] environment = env.getenvAsPairs();
        xes.elementOpen(ENVIRONMENT_ELEMENT);
        for (int i = 0; i < environment.length; ++i) {
            RunProfileXMLCodec.encode(xes, environment[i]);
        }
        xes.elementClose(ENVIRONMENT_ELEMENT);
    }

    private static void encode(XMLEncoderStream xes, RunProfile profile) {
        xes.elementOpen(PROFILE_ID, RunProfileXMLCodec.getVersion());
        xes.elementOpen(RUNCOMMAND_PICKLIST_ELEMENT);
        PicklistElement[] elements = profile.getRunCommand().getPicklist().getElements();
        for (int i = elements.length - 1; i >= 0; --i) {
            xes.element(RUNCOMMAND_PICKLIST_ITEM_ELEMENT, elements[i].displayName());
        }
        xes.elementClose(RUNCOMMAND_PICKLIST_ELEMENT);
        xes.element(RUNCOMMAND_ELEMENT, profile.getRunCommand().getValue());
        if (profile.getConfigurationArguments().getModified()) {
            xes.element(ARGUMENTS_ELEMENT, profile.getConfigurationArguments().getValue());
        }
        xes.element(RUNDIR_ELEMENT, profile.getRunDir());
        xes.element(BUILD_FIRST_ELEMENT, "" + profile.getBuildFirst());
        if (profile.getConsoleType().getModified()) {
            xes.element(CONSOLE_TYPE_ELEMENT, Integer.toString(profile.getConsoleType().getValue()));
        }
        xes.element(TERMINAL_TYPE_ELEMENT, Integer.toString(profile.getTerminalType().getValue()));
        xes.element(REMOVE_INSTRUMENTATION_ELEMENT, Integer.toString(profile.getRemoveInstrumentation().getValue()));
        RunProfileXMLCodec.encode(xes, profile.getEnvironment());
        xes.elementClose(PROFILE_ID);
    }

    public void encode(XMLEncoderStream xes) {
        RunProfileXMLCodec.encode(xes, this.profile);
    }
}

