/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyType;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceManager {
    public static final String ROOT = "";
    private static final String PREF_HAS_MIGRATED = "org.eclipse.core.net.hasMigrated";
    private static String HTTP_PROXY_HOST = "org.eclipse.update.core.proxy.host";
    private static String HTTP_PROXY_PORT = "org.eclipse.update.core.proxy.port";
    private static String HTTP_PROXY_ENABLE = "org.eclipse.update.core.proxy.enable";
    private static final int DEFAULT_INT = -1;
    private static final String DEFAULT_STRING = null;
    private static final boolean DEFAULT_BOOLEAN = false;
    private static boolean migrated = false;
    private IEclipsePreferences defaultScope;
    private IEclipsePreferences currentScope;

    private PreferenceManager(String id) {
        this.defaultScope = new DefaultScope().getNode(id);
    }

    public static PreferenceManager createConfigurationManager(String id) {
        PreferenceManager manager = new PreferenceManager(id);
        manager.currentScope = new ConfigurationScope().getNode(id);
        return manager;
    }

    public boolean isMigrated() {
        return migrated;
    }

    public boolean getBoolean(String node, String key) {
        return this.currentScope.node(node).getBoolean(key, this.defaultScope.node(node).getBoolean(key, false));
    }

    public int getInt(String node, String key) {
        return this.currentScope.node(node).getInt(key, this.defaultScope.node(node).getInt(key, -1));
    }

    public String getString(String node, String key) {
        return this.currentScope.node(node).get(key, this.defaultScope.node(node).get(key, DEFAULT_STRING));
    }

    public void putInt(String node, String key, int value) {
        this.currentScope.node(node).putInt(key, value);
    }

    public void putBoolean(String node, String key, boolean value) {
        this.currentScope.node(node).putBoolean(key, value);
    }

    public void putString(String node, String key, String value) {
        this.currentScope.node(node).put(key, value);
    }

    public void addPreferenceChangeListener(String node, IEclipsePreferences.IPreferenceChangeListener listener) {
        ((IEclipsePreferences)this.currentScope.node(node)).addPreferenceChangeListener(listener);
    }

    public void removePreferenceChangeListener(String node, IEclipsePreferences.IPreferenceChangeListener listener) {
        ((IEclipsePreferences)this.currentScope.node(node)).removePreferenceChangeListener(listener);
    }

    public void addNodeChangeListener(String node, IEclipsePreferences.INodeChangeListener listener) {
        ((IEclipsePreferences)this.currentScope.node(node)).addNodeChangeListener(listener);
    }

    public void removeNodeChangeListener(String node, IEclipsePreferences.INodeChangeListener listener) {
        ((IEclipsePreferences)this.currentScope.node(node)).removeNodeChangeListener(listener);
    }

    public void removeNode(String node) throws BackingStoreException {
        this.currentScope.node(node).removeNode();
    }

    public void flush() throws BackingStoreException {
        this.currentScope.flush();
    }

    public void migrate(ProxyType[] proxies) {
        migrated = true;
        if (this.currentScope.getBoolean(PREF_HAS_MIGRATED, false) || this.currentScope.name().equals("instance")) {
            return;
        }
        this.currentScope.putBoolean(PREF_HAS_MIGRATED, true);
        this.migrateInstanceScopePreferences((Preferences)new InstanceScope().getNode("org.eclipse.core.net"), (Preferences)this.currentScope, proxies, true);
    }

    void migrateInstanceScopePreferences(Preferences instanceScope, Preferences configuration, ProxyType[] proxies, boolean isInitialize) {
        String instanceNonProxiedHosts;
        String instanceEnabled;
        this.migrateUpdateHttpProxy(instanceScope, proxies, isInitialize);
        if (configuration.get("proxiesEnabled", null) == null && (instanceEnabled = instanceScope.get("proxiesEnabled", null)) != null) {
            configuration.put("proxiesEnabled", instanceEnabled);
        }
        if (configuration.get("systemProxiesEnabled", null) == null && (instanceEnabled = instanceScope.get("systemProxiesEnabled", null)) != null) {
            configuration.put("systemProxiesEnabled", instanceEnabled);
        }
        if (configuration.get("nonProxiedHosts", null) == null && (instanceNonProxiedHosts = instanceScope.get("nonProxiedHosts", null)) != null) {
            configuration.put("nonProxiedHosts", instanceNonProxiedHosts);
        }
        PreferenceManager instanceManager = PreferenceManager.createInstanceManager(instanceScope);
        int i = 0;
        while (i < proxies.length) {
            ProxyType instanceType;
            IProxyData instanceData;
            ProxyType type = proxies[i];
            IProxyData data = type.getProxyData(1);
            if (data.getHost() == null && (instanceData = (instanceType = new ProxyType(type.getName(), instanceManager)).getProxyData(1)).getHost() != null) {
                type.setProxyData(instanceData);
            }
            ++i;
        }
        if (!isInitialize) {
            try {
                instanceScope.removeNode();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private void migrateUpdateHttpProxy(Preferences instanceScope, ProxyType[] proxies, boolean isInitialize) {
        if (!instanceScope.getBoolean(PREF_HAS_MIGRATED, false)) {
            if (isInitialize) {
                instanceScope.putBoolean(PREF_HAS_MIGRATED, true);
            }
            Preferences updatePrefs = instanceScope.parent().node("org.eclipse.update.core");
            String httpProxyHost = this.getHostToMigrate(updatePrefs, isInitialize);
            int port = this.getPortToMigrate(updatePrefs, isInitialize);
            boolean httpProxyEnable = this.getEnablementToMigrate(updatePrefs, isInitialize);
            if (httpProxyHost != null) {
                ProxyData proxyData = new ProxyData("HTTP", httpProxyHost, port, false, null);
                int i = 0;
                while (i < proxies.length) {
                    ProxyType type = proxies[i];
                    if (type.getName().equals(proxyData.getType())) {
                        type.updatePreferencesIfMissing(proxyData);
                    }
                    ++i;
                }
                if (httpProxyEnable) {
                    instanceScope.putBoolean("proxiesEnabled", true);
                }
            }
        }
    }

    private String getHostToMigrate(Preferences updatePrefs, boolean checkSystemProperties) {
        String httpProxyHost = updatePrefs.get(HTTP_PROXY_HOST, ROOT);
        if (checkSystemProperties && ROOT.equals(httpProxyHost)) {
            httpProxyHost = System.getProperty("http.proxyHost", ROOT);
        }
        if (ROOT.equals(httpProxyHost)) {
            httpProxyHost = null;
        }
        updatePrefs.remove(HTTP_PROXY_HOST);
        return httpProxyHost;
    }

    private int getPortToMigrate(Preferences updatePrefs, boolean checkSystemProperties) {
        String httpProxyPort = updatePrefs.get(HTTP_PROXY_PORT, ROOT);
        if (checkSystemProperties && ROOT.equals(httpProxyPort)) {
            httpProxyPort = System.getProperty("http.proxyPort", ROOT);
        }
        updatePrefs.remove(HTTP_PROXY_PORT);
        int port = -1;
        if (httpProxyPort != null && !ROOT.equals(httpProxyPort)) {
            try {
                port = Integer.parseInt(httpProxyPort);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return port;
    }

    private boolean getEnablementToMigrate(Preferences updatePrefs, boolean checkSystemProperties) {
        boolean httpProxyEnable = false;
        if (checkSystemProperties && updatePrefs.get(HTTP_PROXY_ENABLE, null) == null) {
            httpProxyEnable = Boolean.getBoolean("http.proxySet");
        } else {
            httpProxyEnable = updatePrefs.getBoolean(HTTP_PROXY_ENABLE, false);
            updatePrefs.remove(HTTP_PROXY_ENABLE);
        }
        return httpProxyEnable;
    }

    private static PreferenceManager createInstanceManager(Preferences instance) {
        PreferenceManager manager = new PreferenceManager("org.eclipse.core.net");
        manager.currentScope = (IEclipsePreferences)instance;
        return manager;
    }
}

