/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public class DirtiesContextTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(DirtiesContextTestExecutionListener.class);

    protected void dirtyContext(TestContext testContext, DirtiesContext.HierarchyMode hierarchyMode) {
        testContext.markApplicationContextDirty(hierarchyMode);
        testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        DirtiesContext.ClassMode classMode;
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull(testClass, (String)"The test class of the supplied TestContext must not be null");
        Method testMethod = testContext.getTestMethod();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        String annotationType = DirtiesContext.class.getName();
        AnnotationAttributes methodAnnAttrs = AnnotatedElementUtils.getAnnotationAttributes((AnnotatedElement)testMethod, (String)annotationType);
        AnnotationAttributes classAnnAttrs = AnnotatedElementUtils.getAnnotationAttributes(testClass, (String)annotationType);
        boolean methodDirtiesContext = methodAnnAttrs != null;
        boolean classDirtiesContext = classAnnAttrs != null;
        DirtiesContext.ClassMode classMode2 = classMode = classDirtiesContext ? (DirtiesContext.ClassMode)classAnnAttrs.getEnum("classMode") : null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("After test method: context %s, class dirties context [%s], class mode [%s], method dirties context [%s].", new Object[]{testContext, classDirtiesContext, classMode, methodDirtiesContext}));
        }
        if (methodDirtiesContext || classMode == DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD) {
            DirtiesContext.HierarchyMode hierarchyMode = methodDirtiesContext ? (DirtiesContext.HierarchyMode)methodAnnAttrs.getEnum("hierarchyMode") : (DirtiesContext.HierarchyMode)classAnnAttrs.getEnum("hierarchyMode");
            this.dirtyContext(testContext, hierarchyMode);
        }
    }

    @Override
    public void afterTestClass(TestContext testContext) throws Exception {
        boolean dirtiesContext;
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull(testClass, (String)"The test class of the supplied TestContext must not be null");
        String annotationType = DirtiesContext.class.getName();
        AnnotationAttributes annAttrs = AnnotatedElementUtils.getAnnotationAttributes(testClass, (String)annotationType);
        boolean bl = dirtiesContext = annAttrs != null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("After test class: context %s, dirtiesContext [%s].", testContext, dirtiesContext));
        }
        if (dirtiesContext) {
            DirtiesContext.HierarchyMode hierarchyMode = (DirtiesContext.HierarchyMode)annAttrs.getEnum("hierarchyMode");
            this.dirtyContext(testContext, hierarchyMode);
        }
    }
}

