/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAttributesRequestMarshaller
implements Marshaller<Request<GetAttributesRequest>, GetAttributesRequest> {
    @Override
    public Request<GetAttributesRequest> marshall(GetAttributesRequest getAttributesRequest) {
        DefaultRequest<GetAttributesRequest> request = new DefaultRequest<GetAttributesRequest>(getAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "GetAttributes");
        request.addParameter("Version", "2009-04-15");
        if (getAttributesRequest != null && getAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(getAttributesRequest.getDomainName()));
        }
        if (getAttributesRequest != null && getAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString(getAttributesRequest.getItemName()));
        }
        if (getAttributesRequest != null) {
            List<String> attributeNamesList = getAttributesRequest.getAttributeNames();
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString(attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        if (getAttributesRequest != null && getAttributesRequest.isConsistentRead() != null) {
            request.addParameter("ConsistentRead", StringUtils.fromBoolean(getAttributesRequest.isConsistentRead()));
        }
        return request;
    }
}

