/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.css.editor.URLRetriever;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.lib.api.CssModule;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class StandardPropertiesHelpResolver
extends HelpResolver {
    private static final Map<String, String> propertyNamesTranslationTable = new HashMap<String, String>();
    private static final Logger LOGGER;
    private static final String SPEC_ARCHIVE_NAME = "docs/css3-spec.zip";
    private static String SPEC_ARCHIVE_INTERNAL_URL;
    private static final String W3C_SPEC_URL_PREFIX = "http://www.w3.org/TR/";
    private static final String MODULE_ARCHIVE_PATH = "www.w3.org/TR/";
    private static final String INDEX_HTML_FILE_NAME = "index.html";
    private static final String NO_HELP_MSG;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getHelp(FileObject context, PropertyDefinition property) {
        CssModule cssModule = property.getCssModule();
        if (cssModule == null) {
            return null;
        }
        String moduleDocBase = cssModule.getSpecificationURL();
        if (moduleDocBase == null) {
            return null;
        }
        if ("http://www.w3.org/TR/CSS2".equals(moduleDocBase)) {
            return null;
        }
        if (!moduleDocBase.startsWith(W3C_SPEC_URL_PREFIX)) return NO_HELP_MSG;
        String moduleFolderName = moduleDocBase.substring(W3C_SPEC_URL_PREFIX.length());
        StringBuilder propertyUrl = new StringBuilder();
        propertyUrl.append(this.getSpecURL());
        propertyUrl.append(MODULE_ARCHIVE_PATH);
        propertyUrl.append(moduleFolderName);
        propertyUrl.append('/');
        propertyUrl.append(INDEX_HTML_FILE_NAME);
        propertyUrl.append('#');
        propertyUrl.append(property.getName());
        try {
            URL propertyHelpURL = new URL(propertyUrl.toString());
            String urlContent = URLRetriever.getURLContentAndCache(propertyHelpURL);
            assert (urlContent != null) : "null " + propertyHelpURL;
            String elementName = "dfn";
            String modifiedPropertyName = propertyNamesTranslationTable.get(property.getName());
            String propertyName = modifiedPropertyName != null ? modifiedPropertyName : property.getName();
            String patternImg = String.format("(?s)<%s[^>]*id=['\"]?\\w*-??propdef-%s\\d?['\"]?[^>]*>", elementName, propertyName);
            Pattern pattern = Pattern.compile(patternImg);
            Matcher matcher = pattern.matcher(urlContent);
            if (!matcher.find(0)) {
                patternImg = String.format("(?s)<%s[^>]*id=['\"]?\\w*-??%s\\d?['\"]?>", elementName, propertyName);
                pattern = Pattern.compile(patternImg);
                matcher = pattern.matcher(urlContent);
            }
            if (!matcher.find(0)) {
                patternImg = String.format("(?s)<%s[^>]*id=['\"]?\\w*-??%s\\d?['\"]?[^>]*>", elementName, propertyName);
                pattern = Pattern.compile(patternImg);
                matcher = pattern.matcher(urlContent);
            }
            if (!matcher.find(0)) {
                LOGGER.warning(String.format("No property anchor section pattern found for property '%s'", property.getName()));
                int styleSectionStart = urlContent.indexOf("<style type=\"text/css\">");
                if (styleSectionStart < 0) return urlContent;
                String styleEndTag = "</style>";
                int styleSectionEnd = urlContent.indexOf("</style>", styleSectionStart);
                if (styleSectionEnd < 0) return urlContent;
                StringBuilder buf = new StringBuilder();
                buf.append(urlContent.subSequence(0, styleSectionStart));
                buf.append(urlContent.subSequence(styleSectionEnd + "</style>".length(), urlContent.length()));
                return buf.toString();
            }
            int sectionStart = -1;
            int from = matcher.start();
            int state = 0;
            block7: for (int i = from; i > 0; --i) {
                char c = urlContent.charAt(i);
                switch (state) {
                    case 0: {
                        if (c != '2' && c != '3' && c != '4') break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (c == 'h') {
                            state = 2;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (c == '<') {
                            sectionStart = i;
                            break block7;
                        }
                        state = 0;
                    }
                }
            }
            if (sectionStart < 0) return NO_HELP_MSG;
            Pattern sectionEndFinder = Pattern.compile("(?s)<h[234]");
            Matcher findSectionEnd = sectionEndFinder.matcher(urlContent.subSequence(from, urlContent.length()));
            if (!findSectionEnd.find()) return NO_HELP_MSG;
            String help = urlContent.substring(sectionStart, from + findSectionEnd.start());
            return help.replaceAll("[A-Za-z-]+\\.(png|jpg)\"", this.getSpecURL() + MODULE_ARCHIVE_PATH + moduleFolderName + "/" + "$0");
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return NO_HELP_MSG;
    }

    @Override
    public URL resolveLink(FileObject context, PropertyDefinition property, String link) {
        return null;
    }

    @Override
    public int getPriority() {
        return 500;
    }

    private synchronized String getSpecURL() {
        if (SPEC_ARCHIVE_INTERNAL_URL == null) {
            SPEC_ARCHIVE_INTERNAL_URL = this.createSpecURL();
        }
        return SPEC_ARCHIVE_INTERNAL_URL;
    }

    private String createSpecURL() {
        File file = InstalledFileLocator.getDefault().locate(SPEC_ARCHIVE_NAME, "org.netbeans.modules.css.editor", false);
        if (file != null) {
            try {
                URL urll = Utilities.toURI((File)file).toURL();
                assert (FileUtil.isArchiveFile((URL)urll));
                return FileUtil.getArchiveRoot((URL)urll).toExternalForm();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, String.format("Error obtaining archive root URL for file '%s'", file.getAbsolutePath()), e);
            }
        } else {
            LOGGER.warning(String.format("Cannot locate the css documentation file '%s'.", SPEC_ARCHIVE_NAME));
        }
        return null;
    }

    static {
        propertyNamesTranslationTable.put("line-break", "line-break0");
        LOGGER = Logger.getLogger(HelpResolver.class.getName());
        NO_HELP_MSG = NbBundle.getMessage(StandardPropertiesHelpResolver.class, (String)"completion-help-no-documentation-found");
    }
}

