/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.terminal.action;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.terminal.spi.ui.ExternalCommandActionProvider;
import org.netbeans.modules.terminal.support.OpenInEditorAction;
import org.openide.util.Lookup;

public class OpenInEditorActionProvider
extends ExternalCommandActionProvider {
    private static final String IDE_OPEN = "ideopen";

    public boolean canHandle(String command) {
        return command != null && command.trim().startsWith(IDE_OPEN);
    }

    public void handle(String command, Lookup lookup) {
        command = command.substring(IDE_OPEN.length() + 1).trim();
        ArrayList<String> paths = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(command);
        while (m.find()) {
            paths.add(m.group(1));
        }
        for (String path : paths) {
            int lineNumber = -1;
            String filePath = path;
            int colonIdx = command.lastIndexOf(58);
            if (colonIdx > 2) {
                try {
                    lineNumber = Integer.parseInt(command.substring(colonIdx + 1));
                    filePath = command.substring(0, colonIdx);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!filePath.startsWith("/") && !filePath.startsWith("~")) {
                filePath = (String)lookup.lookup(String.class) + "/" + filePath;
            }
            Object key = ((Term)lookup.lookup(Term.class)).getClientProperty((Object)"ExecutionEnvironment_KEY");
            URL url = null;
            try {
                ExecutionEnvironment env;
                if (key != null && key instanceof String && (env = ExecutionEnvironmentFactory.fromUniqueID((String)((String)key))).isRemote()) {
                    url = new URL("rfs://" + key + filePath);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (url != null) {
                OpenInEditorAction.post(url, (int)lineNumber);
                continue;
            }
            OpenInEditorAction.post((String)filePath, (int)lineNumber);
        }
    }
}

