/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.util.Arrays;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.parsing.api.Snapshot;

public class JSHintSupport {
    private static String GLOBAL_DIRECTIVE = "global";

    public static void addGlobalInline(Snapshot snapshot, int offset, String name) throws BadLocationException {
        Document document = snapshot.getSource().getDocument(false);
        if (document != null) {
            Collection definedGlobal = ModelUtils.getDefinedGlobal((Snapshot)snapshot, (int)0);
            Identifier lastOne = null;
            for (Identifier iden : definedGlobal) {
                if (lastOne != null && lastOne.getOffsetRange().getEnd() >= iden.getOffsetRange().getEnd()) continue;
                lastOne = iden;
            }
            int insertWhere = -1;
            String insertText = null;
            if (lastOne != null) {
                insertWhere = lastOne.getOffsetRange().getEnd();
                insertText = ", " + name;
            } else {
                TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)snapshot, (int)offset);
                if (ts != null) {
                    Token token;
                    ts.move(0);
                    if (ts.moveNext() && (token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.BLOCK_COMMENT, JsTokenId.WHITESPACE, JsTokenId.EOL))) != null) {
                        insertWhere = ts.offset();
                        StringBuilder sb = new StringBuilder();
                        sb.append("/* ").append(GLOBAL_DIRECTIVE).append(" ").append(name).append(" */\n\n");
                        insertText = sb.toString();
                    }
                }
            }
            if (insertWhere > -1) {
                document.insertString(insertWhere, insertText, null);
            }
        }
    }
}

