/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.awt.Image;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class ProjectFilesNode
extends AbstractNode {
    private static final String PF_BADGE = "org/netbeans/modules/groovy/grailsproject/resources/projectfilesBadge.png";
    private static final String ICON_PATH = "org/netbeans/modules/groovy/grailsproject/resources/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/groovy/grailsproject/resources/defaultFolderOpen.gif";

    public ProjectFilesNode(GrailsProject project) {
        super(Children.create((ChildFactory)new ProjectFilesChildren(project), (boolean)true), Lookups.fixed((Object[])new Object[]{project.getProjectDirectory()}));
    }

    public final Image getIcon(int param) {
        return this.getIcon(false);
    }

    public final Image getOpenedIcon(int param) {
        return this.getIcon(true);
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)PF_BADGE, (boolean)true);
        Image base = ImageUtilities.loadImage((String)(opened ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
        Image img = ImageUtilities.mergeImages((Image)base, (Image)badge, (int)8, (int)8);
        return img;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ProjectFilesNode.class, (String)"LBL_ProjectFiles");
    }

    private static class ProjectFilesChildren
    extends ChildFactory.Detachable<FileObject> {
        private final GrailsProject project;
        private final FileChangeAdapter fileChangeListener;

        ProjectFilesChildren(GrailsProject proj) {
            this.project = proj;
            this.fileChangeListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    ProjectFilesChildren.this.refresh(false);
                }

                public void fileDeleted(FileEvent fe) {
                    ProjectFilesChildren.this.refresh(false);
                }
            };
        }

        protected Node createNodeForKey(FileObject key) {
            try {
                return DataObject.find((FileObject)key).getNodeDelegate().cloneNode();
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        protected boolean createKeys(List<FileObject> keys) {
            FileObject root = this.project.getProjectDirectory();
            keys.add(root.getFileObject("build.gradle"));
            keys.add(root.getFileObject("gradle.properties"));
            keys.add(root.getFileObject("application.properties"));
            keys.removeAll(Collections.singleton(null));
            return true;
        }

        protected void addNotify() {
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.fileChangeListener);
        }

        protected void removeNotify() {
            this.project.getProjectDirectory().removeFileChangeListener((FileChangeListener)this.fileChangeListener);
        }
    }
}

