/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding.pim;

import java.util.Vector;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import org.netbeans.microedition.databinding.DataBindingException;
import org.netbeans.microedition.databinding.DataSet;
import org.netbeans.microedition.databinding.pim.Query;

public class AddressDataSet
implements DataSet {
    public static final String COUNTRY = "country";
    public static final String LOCALITY = "locality";
    public static final String ZIP = "zip";
    public static final String STREET = "street";
    public static final String REGION = "region";
    public static final String EXTRA = "extra";
    public static final String POBOX = "pobox";
    private Vector supportedFields = new Vector();
    private int contactIndex;
    private int attribute;

    public AddressDataSet(int contactIndex, int attribute) {
        this.contactIndex = contactIndex;
        this.attribute = attribute;
        try {
            ContactList contacts = (ContactList)PIM.getInstance().openPIMList(1, 1);
            contacts.createContact();
            int[] fields = contacts.getSupportedArrayElements(100);
            for (int i = 0; i < fields.length; ++i) {
                switch (fields[i]) {
                    case 6: {
                        this.supportedFields.addElement(COUNTRY);
                        break;
                    }
                    case 2: {
                        this.supportedFields.addElement(STREET);
                    }
                }
                System.err.println(" - - " + contacts.getArrayElementLabel(100, fields[i]));
            }
        }
        catch (PIMException e) {
            e.printStackTrace();
        }
    }

    public Class getType(String dataItemName) throws DataBindingException {
        return null;
    }

    public Object getValue(String dataItemName) throws DataBindingException {
        if (!this.supportedFields.contains(dataItemName)) {
            throw new DataBindingException("Unsupported item name: " + dataItemName);
        }
        if (COUNTRY.equals(dataItemName)) {
            return Query.getContactArrayValue(this.contactIndex, this.attribute, 100, 6);
        }
        if (STREET.equals(dataItemName)) {
            return Query.getContactArrayValue(this.contactIndex, this.attribute, 100, 2);
        }
        if (LOCALITY.equals(dataItemName)) {
            return Query.getContactArrayValue(this.contactIndex, this.attribute, 100, 3);
        }
        if (ZIP.equals(dataItemName)) {
            return Query.getContactArrayValue(this.contactIndex, this.attribute, 100, 5);
        }
        if (REGION.equals(dataItemName)) {
            return Query.getContactArrayValue(this.contactIndex, this.attribute, 100, 4);
        }
        if (EXTRA.equals(dataItemName)) {
            return Query.getContactArrayValue(this.contactIndex, this.attribute, 100, 1);
        }
        if (POBOX.equals(dataItemName)) {
            return Query.getContactArrayValue(this.contactIndex, this.attribute, 100, 0);
        }
        throw new DataBindingException("Invalid data item name: " + dataItemName);
    }

    public void setValue(String dataItemName, Object value) throws DataBindingException {
        if (!this.supportedFields.contains(dataItemName)) {
            throw new DataBindingException("Unsupported item name: " + dataItemName);
        }
        if (!(value instanceof String)) {
            throw new DataBindingException("Unsupported value type.");
        }
        this.setAsString(dataItemName, (String)value);
    }

    public void setAsString(String dataItemName, String value) throws DataBindingException {
        if (!this.supportedFields.contains(dataItemName)) {
            throw new DataBindingException("Unsupported item name: " + dataItemName);
        }
        if (COUNTRY.equals(dataItemName)) {
            Query.setContactArrayValue(this.contactIndex, this.attribute, 100, 6, value);
            return;
        }
        if (STREET.equals(dataItemName)) {
            Query.setContactArrayValue(this.contactIndex, this.attribute, 100, 2, value);
            return;
        }
        if (LOCALITY.equals(dataItemName)) {
            Query.setContactArrayValue(this.contactIndex, this.attribute, 100, 3, value);
            return;
        }
        if (ZIP.equals(dataItemName)) {
            Query.setContactArrayValue(this.contactIndex, this.attribute, 100, 5, value);
            return;
        }
        if (REGION.equals(dataItemName)) {
            Query.setContactArrayValue(this.contactIndex, this.attribute, 100, 4, value);
            return;
        }
        if (EXTRA.equals(dataItemName)) {
            Query.setContactArrayValue(this.contactIndex, this.attribute, 100, 1, value);
            return;
        }
        if (POBOX.equals(dataItemName)) {
            Query.setContactArrayValue(this.contactIndex, this.attribute, 100, 0, value);
            return;
        }
        throw new DataBindingException("Invalid data item name: " + dataItemName);
    }

    public boolean isReadOnly(String dataItemName) throws DataBindingException {
        return false;
    }
}

