/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandlerFactory;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerRootNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.PrioritizedCustomizerNode;
import org.netbeans.modules.cnd.makeproject.spi.DebuggerChooserProvider;
import org.openide.util.Lookup;

public class DebuggerChooserProviderImpl
extends DebuggerChooserProvider {
    private static List<CustomizerNode> nodes;
    private static String[] names;
    private static int def;

    public DebuggerChooserProviderImpl() {
        Lookup lookup = Lookup.EMPTY;
        if (nodes == null) {
            nodes = CustomizerRootNodeProvider.getInstance().getCustomizerNodes("Debug", lookup);
            String[] defnames = new String[]{""};
            if (nodes.size() >= 1) {
                int priority = -1;
                int idx = 0;
                ArrayList<String> n = new ArrayList<String>();
                for (CustomizerNode node : nodes) {
                    if (node instanceof PrioritizedCustomizerNode) {
                        if (((PrioritizedCustomizerNode)((Object)node)).getPriority() > priority) {
                            priority = ((PrioritizedCustomizerNode)((Object)node)).getPriority();
                            idx = n.size();
                        }
                    } else if (node.getClass().getName().toLowerCase(Locale.getDefault()).contains("dbx")) {
                        priority = 9999;
                        idx = n.size();
                    }
                    n.add(node.getDisplayName());
                }
                names = n.toArray(defnames);
                def = idx;
            } else {
                names = defnames;
                def = 0;
            }
        }
    }

    public String getName(int i) {
        if (i < names.length) {
            return names[i];
        }
        return "???";
    }

    public ProjectActionHandlerFactory getNode(int i) {
        CustomizerNode node;
        if (i < nodes.size() && (node = nodes.get(i)) instanceof ProjectActionHandlerFactory) {
            return (ProjectActionHandlerFactory)node;
        }
        return null;
    }

    public String[] getNames() {
        return names;
    }

    public int getDefault() {
        return def;
    }

    public int getNodesSize() {
        return nodes.size();
    }
}

