/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.runprofiles;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.ComboStringNodeProp;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.runprofiles.ConsoleIntNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.runprofiles.DirectoryChooserPanel;
import org.netbeans.modules.cnd.makeproject.ui.runprofiles.EnvPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RunProfileNodeProvider
implements CustomizerNodeProvider {
    private CustomizerNode customizerNode = null;

    @Override
    public CustomizerNode factoryCreate(Lookup lookup) {
        if (this.customizerNode == null) {
            this.customizerNode = this.createProfileNode(lookup);
        }
        return this.customizerNode;
    }

    public CustomizerNode createProfileNode(Lookup lookup) {
        return new RunProfileCustomizerNode("Run", RunProfileNodeProvider.getString("RUNNING"), null, lookup);
    }

    private static String getString(String s) {
        return NbBundle.getBundle(RunProfileNodeProvider.class).getString(s);
    }

    private static Sheet getSheet(boolean disableConsoleTypeSelection, RunProfile run) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(RunProfileNodeProvider.getString("GeneralName"));
        set.setShortDescription(RunProfileNodeProvider.getString("GeneralTT"));
        String runComboHintSuffix = null;
        ExecutionEnvironment targetEnv = run.getMakeConfiguration().getDevelopmentHost().getExecutionEnvironment();
        if (!Utilities.isWindows() && HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)targetEnv)) {
            try {
                String shell = HostInfoUtils.getHostInfo((ExecutionEnvironment)targetEnv).getShell();
                if (shell != null) {
                    shell = CndPathUtilities.getBaseName((String)shell);
                    runComboHintSuffix = NbBundle.getMessage(RunProfileNodeProvider.class, (String)"ShellSyntaxSupported", (Object)shell);
                }
            }
            catch (IOException shell) {
            }
            catch (ConnectionManager.CancellationException shell) {
                // empty catch block
            }
        }
        String runComboName = RunProfileNodeProvider.getString("RunCommandName");
        String runComboHint = RunProfileNodeProvider.getString("RunCommandHint");
        if (runComboHintSuffix != null) {
            runComboHint = runComboHint.concat("<br>").concat(runComboHintSuffix);
        }
        set.put((Node.Property)new ComboStringNodeProp(run.getRunCommand(), true, runComboName, runComboHint));
        set.put((Node.Property)new RunDirectoryNodeProp(run));
        StringNodeProp argumentsNodeprop = new StringNodeProp(run.getConfigurationArguments(), "", "Arguments", RunProfileNodeProvider.getString("ArgumentsName"), RunProfileNodeProvider.getString("ArgumentsHint"));
        set.put((Node.Property)argumentsNodeprop);
        argumentsNodeprop.setHidden(true);
        set.put((Node.Property)new EnvNodeProp(run));
        set.put((Node.Property)new BuildFirstNodeProp(run));
        ConsoleIntNodeProp consoleTypeNP = new ConsoleIntNodeProp(run.getConsoleType(), true, "ConsoleType", RunProfileNodeProvider.getString("ConsoleType_LBL"), RunProfileNodeProvider.getString("ConsoleType_HINT"));
        set.put((Node.Property)consoleTypeNP);
        IntNodeProp terminalTypeNP = new IntNodeProp(run.getTerminalType(), true, "TerminalType", RunProfileNodeProvider.getString("TerminalType_LBL"), RunProfileNodeProvider.getString("TerminalType_HINT"));
        set.put((Node.Property)terminalTypeNP);
        if (disableConsoleTypeSelection) {
            terminalTypeNP.setCanWrite(false);
            consoleTypeNP.setCanWrite(false);
        } else {
            consoleTypeNP.addPropertyChangeListener(evt -> {
                String value = (String)evt.getNewValue();
                RunProfileNodeProvider.updateTerminalTypeState(terminalTypeNP, value, run.getConsoleType());
            });
            RunProfileNodeProvider.updateTerminalTypeState(terminalTypeNP, run.getConsoleType().getNames()[(Integer)consoleTypeNP.getValue() - 1], run.getConsoleType());
        }
        if (RunProfile.thaSupportEnabled()) {
            set.put((Node.Property)new IntNodeProp(run.getRemoveInstrumentation(), true, "RemoveInstrumentation", RunProfileNodeProvider.getString("RemoveInstrumentation_LBL"), RunProfileNodeProvider.getString("RemoveInstrumentation_HINT")));
        }
        sheet.put(set);
        return sheet;
    }

    private static void updateTerminalTypeState(IntNodeProp terminalTypeNP, String value, IntConfiguration consoles) {
        terminalTypeNP.setCanWrite(consoles.getNames()[0].equals(value));
    }

    private static class EnvEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private final Env env;
        private PropertyEnv propenv;

        public EnvEditor(Env env) {
            this.env = env;
        }

        @Override
        public void setAsText(String text) {
        }

        @Override
        public String getAsText() {
            return this.env.toString();
        }

        @Override
        public Component getCustomEditor() {
            return new EnvPanel(this.env, this, this.propenv);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private static class EnvNodeProp
    extends PropertySupport<Env> {
        private final RunProfile run;

        public EnvNodeProp(RunProfile run) {
            super("Environment", Env.class, RunProfileNodeProvider.getString("EnvironmentName"), RunProfileNodeProvider.getString("EnvironmentHint"), true, true);
            this.run = run;
        }

        public Env getValue() {
            return this.run.getEnvironment();
        }

        public void setValue(Env v) {
            this.run.getEnvironment().assign(v);
        }

        public PropertyEditor getPropertyEditor() {
            return new EnvEditor(this.run.getEnvironment().clone());
        }

        public Object getValue(String attributeName) {
            if (attributeName.equals("canEditAsText")) {
                return Boolean.FALSE;
            }
            return super.getValue(attributeName);
        }
    }

    private static class BuildFirstNodeProp
    extends PropertySupport<Boolean> {
        private final RunProfile run;

        public BuildFirstNodeProp(RunProfile run) {
            super("Build First", Boolean.class, RunProfileNodeProvider.getString("BuildFirstName"), RunProfileNodeProvider.getString("BuildFirstHint"), true, true);
            this.run = run;
        }

        public Boolean getValue() {
            return this.run.getBuildFirst();
        }

        public void setValue(Boolean v) {
            this.run.setBuildFirst(v.booleanValue());
        }
    }

    private static class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private final String seed;
        private final RunProfile run;

        public DirEditor(String seed, RunProfile run) {
            this.seed = seed;
            this.run = run;
        }

        @Override
        public void setAsText(String text) {
            this.run.setRunDir(text);
        }

        @Override
        public String getAsText() {
            return this.run.getRunDir();
        }

        @Override
        public Object getValue() {
            return this.run.getRunDir();
        }

        @Override
        public void setValue(Object v) {
            this.run.setRunDir((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            FileSystem fs = this.run.getMakeConfiguration() == null ? CndFileUtils.getLocalFileSystem() : this.run.getMakeConfiguration().getSourceFileSystem();
            return new DirectoryChooserPanel(this.seed, this, this.propenv, fs);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private static class RunDirectoryNodeProp
    extends PropertySupport<String> {
        private final RunProfile run;

        public RunDirectoryNodeProp(RunProfile run) {
            super("Run Directory", String.class, RunProfileNodeProvider.getString("RunDirectoryName"), RunProfileNodeProvider.getString("RunDirectoryHint"), true, true);
            this.run = run;
        }

        public String getValue() {
            return this.run.getRunDir();
        }

        public void setValue(String v) {
            String path = CndPathUtilities.toAbsoluteOrRelativePath((String)this.run.getBaseDir(), (String)v);
            path = CndPathUtilities.normalizeSlashes((String)path);
            this.run.setRunDir(path);
        }

        public PropertyEditor getPropertyEditor() {
            String runDir2 = this.run.getRunDir();
            if (runDir2.length() == 0) {
                runDir2 = ".";
            }
            String seed = CndPathUtilities.isPathAbsolute((CharSequence)runDir2) ? runDir2 : this.run.getBaseDir() + File.separatorChar + runDir2;
            return new DirEditor(seed, this.run);
        }
    }

    private static class RunProfileCustomizerNode
    extends CustomizerNode {
        public RunProfileCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
            super(name, displayName, children, lookup);
        }

        @Override
        public Sheet[] getSheets(Configuration configuration) {
            Sheet[] sheetArray;
            RunProfile runProfile = (RunProfile)configuration.getAuxObject("runprofile");
            boolean disableConsoleTypeSelection = false;
            if (runProfile != null) {
                Sheet[] sheetArray2 = new Sheet[1];
                sheetArray = sheetArray2;
                sheetArray2[0] = RunProfileNodeProvider.getSheet(disableConsoleTypeSelection, runProfile);
            } else {
                sheetArray = null;
            }
            return sheetArray;
        }

        @Override
        public HelpCtx getHelpCtx() {
            return new HelpCtx("ProjectPropsRunning");
        }
    }
}

