/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class ToolTipView
extends JComponent
implements ExplorerManager.Provider {
    private static final ToolTipView INSTANCE = new ToolTipView();
    private static final ExplorerManager manager = new ExplorerManager();
    private static RequestProcessor RP = new RequestProcessor(ToolTipView.class.getName());
    private volatile ActionListener listener;
    public static final int ON_DISPOSE = 0;

    public static ToolTipView getDefault() {
        return INSTANCE;
    }

    public ToolTipView() {
        OutlineView ov = new OutlineView();
        ov.setPropertyColumns(new String[]{"value", "Value"});
        ov.getOutline().getColumnModel().getColumn(0).setHeaderValue("Name");
        ov.getOutline().setRootVisible(true);
        ov.setVerticalScrollBarPolicy(22);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getForeground()), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.setLayout(new BorderLayout());
        this.add((Component)ov, "Center");
    }

    public ToolTipView setRootElement(Node node) {
        this.getExplorerManager().setRootContext(node);
        return this;
    }

    public ToolTipView setOnDisposeListener(ActionListener listener) {
        this.listener = listener;
        return this;
    }

    public void showTooltip() {
        JEditorPane ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
        EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
        ToolTipSupport toolTipSupport = eui.getToolTipSupport();
        toolTipSupport.setToolTipVisible(true);
        toolTipSupport.setToolTip((JComponent)this, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0, 4);
    }

    public ExplorerManager getExplorerManager() {
        return manager;
    }

    @Override
    public void removeNotify() {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, null));
            this.listener = null;
        }
    }

    public static abstract class VariableNodeChildren
    extends Children.Keys<Variable> {
        private final Variable var;

        public VariableNodeChildren(Variable v) {
            this.var = v;
        }

        private void updateKeys() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VariableNodeChildren.this.setKeys(VariableNodeChildren.this.var.getChildren());
                        }
                    });
                }
            });
        }

        protected Node[] createNodes(Variable key) {
            return new Node[]{new VariableNode(key, Children.LEAF)};
        }
    }

    public static final class VariableNode
    extends AbstractNode {
        private Variable v;
        private static final Map<Variable, VariableNode> variables = new HashMap<Variable, VariableNode>();
        private static WatchModel watchModel = new WatchModel();

        public VariableNode(Variable v, Children ch) {
            super(ch);
            this.v = v;
            this.add(v);
        }

        private void add(Variable v) {
            variables.put(v, this);
        }

        public static void propertyChanged(Variable v) {
            final VariableNode node = variables.get(v);
            if (node == null) {
                return;
            }
            if (EventQueue.isDispatchThread()) {
                node.propertyChanged();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        node.propertyChanged();
                    }
                });
            }
        }

        public String getDisplayName() {
            return this.v.getVariableName();
        }

        public Image getIcon(int type) {
            String path = "";
            try {
                path = watchModel.getIconBaseWithExtension(null, this.v);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setIconBaseWithExtension(path);
            return super.getIcon(type);
        }

        private void propertyChanged() {
            if (this.v.getNumChild() < 1) {
                this.setChildren(Children.LEAF);
            } else if (this.getChildren() instanceof VariableNodeChildren) {
                ((VariableNodeChildren)this.getChildren()).updateKeys();
            }
            String path = "";
            try {
                path = watchModel.getIconBaseWithExtension(null, this.v);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setIconBaseWithExtension(path);
            this.fireDisplayNameChange("old", "new");
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{new VariableNodePropertySet(this.v)};
        }

        private final class VariableNodePropertySet
        extends Node.PropertySet {
            private Variable v;

            public VariableNodePropertySet(Variable v) {
                this.v = v;
            }

            public Node.Property<?>[] getProperties() {
                Node.Property[] ps = new Node.Property[]{new Node.Property<String>(String.class){

                    public String getName() {
                        return "value";
                    }

                    public boolean canRead() {
                        return true;
                    }

                    public String getValue() throws IllegalAccessException, InvocationTargetException {
                        return VariableNodePropertySet.this.v.getAsText();
                    }

                    public boolean canWrite() {
                        return false;
                    }

                    public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    }
                }};
                return ps;
            }
        }
    }
}

