/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.values;

import java.awt.Color;

public class VariableValue {
    public String text;
    public boolean bold;

    public VariableValue(String text, boolean bold) {
        this.text = text;
        this.bold = bold;
    }

    public String toString() {
        if (!this.bold) {
            return this.text;
        }
        return VariableValue.toHTML(this.text, true, false, null);
    }

    public static String bold(String text) {
        return VariableValue.toHTML(text, true, false, null);
    }

    public static String toHTML(String text, boolean bold, boolean italics, Color color) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (bold) {
            sb.append("<b>");
        }
        if (italics) {
            sb.append("<i>");
        }
        if (color != null) {
            sb.append("<font color=");
            sb.append(Integer.toHexString(color.getRGB() & 0xFFFFFF));
            sb.append('>');
        }
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        sb.append(text);
        if (color != null) {
            sb.append("</font>");
        }
        if (italics) {
            sb.append("</i>");
        }
        if (bold) {
            sb.append("</b>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

