/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CapProcessor;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import java.util.Hashtable;
import java.util.Vector;

public class CAPUtil {
    static final String initMethodName = "<init>";
    static int genRefNameCount = 0;
    static Hashtable<Integer, String> refNames = new Hashtable();
    static Hashtable<Integer, String> classMethodDescriptors = new Hashtable();
    static Hashtable<Integer, String> instanceMethodNamesByToken = new Hashtable();

    public static String getRefName(int n) {
        String string = refNames.get(new Integer(n));
        if (string == null) {
            EfClass efClass = Classref.checkExportedAndReturnExportClass(n);
            string = efClass != null ? efClass.thisName() : CAPUtil.getConstructedRefName(n);
            refNames.put(new Integer(n), string);
        }
        return string;
    }

    private static String getConstructedRefName(int n) {
        String string = null;
        byte[] byArray = new byte[]{(byte)(CAPUtil.getCharOffset(genRefNameCount, 1) + 65), (byte)(CAPUtil.getCharOffset(genRefNameCount, 2) + 65), (byte)(CAPUtil.getCharOffset(genRefNameCount, 3) + 65)};
        try {
            string = new String(byArray, "US-ASCII");
        }
        catch (Exception exception) {
            System.out.println("Unexpected character encoding exception");
            System.exit(1);
        }
        ++genRefNameCount;
        return CapProcessor.pkgName + "/" + string;
    }

    public static String getClassFieldName(FieldDescriptor fieldDescriptor, EfClass efClass) {
        EfField efField;
        int n = fieldDescriptor.token();
        if (efClass != null && n != 255 && (efField = efClass.getFieldForTokenAndFlag(n, false)) != null) {
            return efField.name();
        }
        return CAPUtil.getConstructedFieldName(fieldDescriptor);
    }

    public static String getClassMethodName(MethodDescriptor methodDescriptor, boolean bl, boolean bl2, EfClass efClass) {
        Object object;
        if (bl2) {
            return new String(initMethodName);
        }
        if (Cap.Applet != null && Cap.Applet.isInstallMethod(methodDescriptor)) {
            return "install";
        }
        int n = methodDescriptor.token();
        if (efClass != null && n != 255 && (object = efClass.getMethodForTokenAndFlag(n, bl | bl2)) != null) {
            return ((EfMethod)object).name();
        }
        object = null;
        if (!bl && !bl2) {
            n = methodDescriptor.token();
            if (n != 255) {
                object = instanceMethodNamesByToken.get(n);
            }
            if (object == null) {
                ClassDescriptor classDescriptor = ClassDescriptor.getClassDescForMethodLoc(methodDescriptor.methodOffset());
                if (classDescriptor != null && (object = CAPUtil.getMethodNameFromImplementedInterfaces(classDescriptor, n)) == null) {
                    int n2 = classDescriptor.thisClass();
                    ClassInfo classInfo = Cap.Class.infoOfs(n2);
                    int n3 = classInfo.superclass();
                    while (n3 != 65535) {
                        EfClass efClass2 = Classref.checkExportedAndReturnExportClass(n3);
                        if (efClass2 != null) {
                            EfMethod efMethod = efClass2.getMethodForTokenAndFlag(n, false);
                            if (efMethod == null) {
                                efMethod = efClass2.getMethodFromSupers(n, false);
                            }
                            if (efMethod == null) break;
                            object = efMethod.name();
                            break;
                        }
                        if (Classref.isExternal(n3)) continue;
                        n3 = Cap.Class.infoOfs(n3).superclass();
                    }
                }
                if (object != null && n != 255) {
                    instanceMethodNamesByToken.put(n, (String)object);
                }
            }
        }
        if (object == null) {
            object = CAPUtil.getConstructedMethodName(methodDescriptor);
            if (!bl && !bl2 && n != 255) {
                instanceMethodNamesByToken.put(methodDescriptor.token(), (String)object);
            }
        }
        return object;
    }

    private static String getMethodNameFromImplementedInterfaces(ClassDescriptor classDescriptor, int n) {
        String string = null;
        int n2 = classDescriptor.interfaceCount();
        int n3 = classDescriptor.thisClass();
        ClassInfo classInfo = Cap.Class.infoOfs(n3);
        if (n2 == 0) {
            return null;
        }
        ImplementedInterface implementedInterface = classInfo.firstImplementedInterface();
        for (int i = 0; i < n2; ++i) {
            int n4 = classDescriptor.interfaceRef(i);
            EfClass efClass = Classref.checkExportedAndReturnExportClass(n4);
            if (efClass == null) {
                implementedInterface.next();
                continue;
            }
            int n5 = implementedInterface.count();
            for (int j = 0; j < n5; ++j) {
                int n6 = implementedInterface.indexMethod(j);
                if (n6 != n) continue;
                EfMethod efMethod = efClass.getMethodForTokenAndFlag(j, false);
                if (efMethod != null) {
                    string = efMethod.name();
                }
                if (string != null) break;
            }
            if (string != null) break;
            implementedInterface.next();
        }
        return string;
    }

    private static String getConstructedFieldName(FieldDescriptor fieldDescriptor) {
        boolean bl = (fieldDescriptor.flags() & 8) == 8;
        String string = bl ? "sfield" : "field";
        string = string + "_token" + fieldDescriptor.token();
        string = string + "_descoff" + fieldDescriptor.getDescOffset();
        if (bl) {
            string = string + "_staticref" + fieldDescriptor.staticRef();
        }
        return string;
    }

    private static String getConstructedMethodName(MethodDescriptor methodDescriptor) {
        boolean bl = (methodDescriptor.flags() & 8) == 8;
        String string = bl ? "smethod" : "method";
        string = string + "_token" + methodDescriptor.token();
        string = string + "_descoff" + methodDescriptor.getDescOffset();
        if (bl) {
            string = string + "_moffset" + methodDescriptor.methodOffset();
        }
        return string;
    }

    public static String getFieldDescrStr(short s) {
        if ((short)(s & Short.MIN_VALUE) == Short.MIN_VALUE) {
            s = (short)(s & Short.MAX_VALUE);
            switch (s) {
                case 2: {
                    return "Z";
                }
                case 3: {
                    return "B";
                }
                case 4: {
                    return "S";
                }
                case 5: {
                    return "I";
                }
            }
            throw new VerifierError("Invalid type descriptor");
        }
        Vector<String> vector = CAPUtil.getTypeDescrStr(s);
        if (vector.size() == 0 || vector.size() > 1) {
            throw new VerifierError("Invalid type descriptor");
        }
        return vector.elementAt(0);
    }

    public static String getMethodDescriptorString(int n) {
        String string = classMethodDescriptors.get(new Integer(n));
        if (string == null) {
            Vector<String> vector = CAPUtil.getTypeDescrStr((short)n);
            int n2 = vector.size();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            for (int i = 0; i < n2 - 1; ++i) {
                stringBuffer.append(vector.elementAt(i));
            }
            stringBuffer.append(")" + vector.elementAt(n2 - 1));
            string = stringBuffer.toString();
            classMethodDescriptors.put(new Integer(n), string);
        }
        return string;
    }

    private static Vector<String> getTypeDescrStr(short s) {
        Vector<String> vector = new Vector<String>();
        Safeptr safeptr = Cap.TypeDescr.at(s);
        int n = safeptr.u1(0);
        int n2 = 2;
        block13: for (n2 = 2; n2 < n + 2; ++n2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = safeptr.nibble(n2);
            switch (n3) {
                case 1: {
                    vector.add("V");
                    continue block13;
                }
                case 2: {
                    vector.add("Z");
                    continue block13;
                }
                case 3: {
                    vector.add("B");
                    continue block13;
                }
                case 4: {
                    vector.add("S");
                    continue block13;
                }
                case 5: {
                    vector.add("I");
                    continue block13;
                }
                case 14: {
                    stringBuffer.append("[");
                }
                case 6: {
                    stringBuffer.append("L");
                    int n4 = safeptr.nibble(++n2);
                    n4 = n4 << 4 | safeptr.nibble(++n2);
                    int n5 = safeptr.nibble(++n2);
                    n5 = n5 << 4 | safeptr.nibble(++n2);
                    int n6 = n4 << 8 | n5;
                    stringBuffer.append(CAPUtil.getRefName(n6) + ";");
                    vector.add(stringBuffer.toString());
                    continue block13;
                }
                case 13: {
                    vector.add("[I");
                    continue block13;
                }
                case 10: {
                    vector.add("[Z");
                    continue block13;
                }
                case 11: {
                    vector.add("[B");
                    continue block13;
                }
                case 12: {
                    vector.add("[S");
                    continue block13;
                }
                default: {
                    throw new VerifierError("Invalid type descriptor for field");
                }
            }
        }
        return vector;
    }

    private static byte getCharOffset(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n % 26;
            n = (n - n3) / 26;
        }
        return (byte)n3;
    }
}

