/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.AttributeInfo;
import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.ClassMemberInfo;
import com.sun.javacard.components.caputils.CodeAttribute;
import com.sun.javacard.components.caputils.ExceptionsAttribute;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JCConstInstr;
import com.sun.javacard.components.caputils.instructions.JCControlInstr;
import com.sun.javacard.components.caputils.instructions.JCFieldAccessInstr;
import com.sun.javacard.components.caputils.instructions.JCObjectInstr;
import com.sun.javacard.components.caputils.instructions.JCPushInstr;
import com.sun.javacard.components.caputils.instructions.JCStackInstr;
import com.sun.javacard.components.caputils.instructions.JCStoreInstr;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassMethodTable {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    private ClassConstantPool constantPool;
    private ClassDescriptor cdesc;
    Hashtable<String, ClassMemberInfo> classMethods;

    public ClassMethodTable(ClassConstantPool classConstantPool, ClassDescriptor classDescriptor, EfClass efClass) {
        this.cdesc = classDescriptor;
        this.constantPool = classConstantPool;
        this.classMethods = new Hashtable();
        int n = classDescriptor.methodCount();
        for (int i = 0; i < n; ++i) {
            MethodDescriptor methodDescriptor = classDescriptor.methodDescr(i);
            int n2 = methodDescriptor.flags();
            boolean bl = (n2 & 8) != 0;
            boolean bl2 = (n2 & 0x80) != 0;
            String string = CAPUtil.getClassMethodName(methodDescriptor, bl, bl2, efClass);
            String string2 = CAPUtil.getMethodDescriptorString(methodDescriptor.type());
            int n3 = classConstantPool.getUtf8InfoIndex(string);
            int n4 = classConstantPool.getUtf8InfoIndex(string2);
            this.addMethod(methodDescriptor, n3, n4);
        }
        this.createCLInitMethod(efClass);
    }

    public void addMethod(MethodDescriptor methodDescriptor, int n, int n2) {
        ClassMemberInfo classMemberInfo = new ClassMemberInfo();
        classMemberInfo.setAccessFlags(this.getMethodFlags((short)methodDescriptor.flags()));
        classMemberInfo.setNameIndex((short)n);
        classMemberInfo.setDescriptorIndex((short)n2);
        this.createMethodAttributes(methodDescriptor, classMemberInfo);
        this.classMethods.put(methodDescriptor.toString(), classMemberInfo);
    }

    private short getMethodFlags(short s) {
        short s2 = 0;
        if ((s & 1) == 1) {
            s2 = (short)(s2 | 1);
        }
        if ((s & 2) == 2) {
            s2 = (short)(s2 | 2);
        }
        if ((s & 4) == 4) {
            s2 = (short)(s2 | 4);
        }
        if ((s & 8) == 8) {
            s2 = (short)(s2 | 8);
        }
        if ((s & 0x10) == 16) {
            s2 = (short)(s2 | 0x10);
        }
        if ((s & 0x40) == 64) {
            s2 = (short)(s2 | 0x400);
        }
        return s2;
    }

    private void createMethodAttributes(MethodDescriptor methodDescriptor, ClassMemberInfo classMemberInfo) {
        if ((methodDescriptor.flags() & 0x40) == 64) {
            return;
        }
        CodeAttribute codeAttribute = new CodeAttribute(this.constantPool, methodDescriptor);
        classMemberInfo.addAttribute(codeAttribute);
        ExceptionsAttribute exceptionsAttribute = new ExceptionsAttribute(this.constantPool, methodDescriptor);
        if (exceptionsAttribute.getExceptionsCount() > 0) {
            // empty if block
        }
    }

    private void createCLInitMethod(EfClass efClass) {
        Object object;
        boolean bl = false;
        int n = 0;
        String string = CAPUtil.getRefName(this.cdesc.thisClass());
        Vector<Instruction> vector = new Vector<Instruction>();
        int n2 = this.cdesc.fieldCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int[] nArray;
            int n4;
            FieldDescriptor fieldDescriptor = this.cdesc.fieldDescr(i);
            String string2 = CAPUtil.getClassFieldName(fieldDescriptor, efClass);
            object = CAPUtil.getFieldDescrStr((short)fieldDescriptor.type());
            if ((fieldDescriptor.flags() & 8) != 8 || !Cap.StaticField.isStaticFieldInitialized(fieldDescriptor)) continue;
            bl = true;
            int n5 = this.constantPool.getCPEntryIndexForClassMember(string, string2, (String)object, 9);
            int n6 = fieldDescriptor.staticRef();
            if ((fieldDescriptor.type() & 0x8000) == 32768) {
                n = n < 4 ? 1 : n;
                int n7 = Cap.StaticField.getPrimitiveFieldValue(fieldDescriptor);
                this.getPrimitiveInitInstrs(n5, n7, vector);
                continue;
            }
            n = 4;
            InitializedArray initializedArray = Cap.StaticField.getArrayInitValues(fieldDescriptor.staticRef());
            Safeptr safeptr = initializedArray.values();
            if (((String)object).equals("[Z") || ((String)object).equals("[B")) {
                n4 = initializedArray.count();
                nArray = new int[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    nArray[n3] = (byte)safeptr.u1(n3);
                }
                this.getArrayInitInstrs(n5, nArray, ((String)object).equals("[Z") ? 4 : 8, 84, vector);
                continue;
            }
            if (((String)object).equals("[S")) {
                n4 = initializedArray.count() / 2;
                nArray = new int[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    nArray[n3] = safeptr.u2(n3 * 2);
                }
                this.getArrayInitInstrs(n5, nArray, 9, 86, vector);
                continue;
            }
            if (!((String)object).equals("[I")) continue;
            n4 = initializedArray.count() / 4;
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[i] = safeptr.s4(i * 4);
            }
            this.getArrayInitInstrs(n5, nArray, 10, 79, vector);
        }
        if (bl) {
            vector.add(new JCControlInstr(177, null));
            ClassMemberInfo classMemberInfo = new ClassMemberInfo();
            classMemberInfo.setAccessFlags((short)8);
            short s = (short)this.constantPool.getUtf8InfoIndex("<clinit>");
            classMemberInfo.setNameIndex(s);
            short s2 = (short)this.constantPool.getUtf8InfoIndex("()V");
            classMemberInfo.setDescriptorIndex(s2);
            object = new CodeAttribute(vector, n, 0, this.constantPool);
            classMemberInfo.addAttribute((AttributeInfo)object);
            this.classMethods.put("<clinit>()", classMemberInfo);
        }
    }

    private void getPrimitiveInitInstrs(int n, int n2, Vector<Instruction> vector) {
        this.pushValueOnStack(n2, vector);
        vector.add(new JCFieldAccessInstr(179, n));
    }

    private void getArrayInitInstrs(int n, int[] nArray, int n2, int n3, Vector<Instruction> vector) {
        this.pushValueOnStack(nArray.length, vector);
        vector.add(new JCObjectInstr(n2));
        for (int i = 0; i < nArray.length; ++i) {
            vector.add(new JCStackInstr(89));
            this.pushValueOnStack(i, vector);
            this.pushValueOnStack(nArray[i], vector);
            vector.add(new JCStoreInstr(n3));
        }
        vector.add(new JCFieldAccessInstr(179, n));
    }

    private void pushValueOnStack(int n, Vector<Instruction> vector) {
        if (n >= -1 && n <= 5) {
            vector.add(new JCConstInstr(n));
        } else {
            vector.add(new JCPushInstr(n, this.constantPool));
        }
    }

    public Enumeration getClassMethods() {
        return this.classMethods.elements();
    }

    public short getMethodCount() {
        return (short)this.classMethods.size();
    }
}

