/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernateweb.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernateweb.framework.HibernateWebModuleExtender;
import org.netbeans.modules.hibernateweb.framework.Util;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class HibernateFrameworkProvider
extends WebFrameworkProvider {
    public HibernateFrameworkProvider() {
        super(NbBundle.getMessage(HibernateFrameworkProvider.class, (String)"HibernateFramework_Name"), NbBundle.getMessage(HibernateFrameworkProvider.class, (String)"HibernateFramework_Description"));
    }

    public boolean isInWebModule(WebModule wm) {
        return this.getDefaultHibernateConfigFiles(wm).size() != 0;
    }

    public WebModuleExtender createWebModuleExtender(WebModule wm, ExtenderController controller) {
        boolean forNewProjectWizard = wm == null || !this.isInWebModule(wm);
        HibernateWebModuleExtender webModuleExtender = new HibernateWebModuleExtender(forNewProjectWizard, wm, controller);
        return webModuleExtender;
    }

    public File[] getConfigurationFiles(WebModule wm) {
        return new File[0];
    }

    private List<FileObject> getDefaultHibernateConfigFiles(WebModule wm) {
        ArrayList<FileObject> configFiles = new ArrayList<FileObject>();
        Project enclosingProject = Util.getEnclosingProjectFromWebModule(wm);
        if (enclosingProject == null) {
            return configFiles;
        }
        HibernateEnvironment he = (HibernateEnvironment)enclosingProject.getLookup().lookup(HibernateEnvironment.class);
        if (he == null) {
            return configFiles;
        }
        configFiles.addAll(he.getDefaultHibernateConfigFileObjects());
        return configFiles;
    }
}

