/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.support.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.ChildrenUpdater;
import org.netbeans.modules.cnd.classview.HostKeyArray;
import org.netbeans.modules.cnd.classview.PersistentKey;
import org.netbeans.modules.cnd.classview.SortedName;
import org.netbeans.modules.cnd.classview.UpdatebleHost;
import org.netbeans.modules.cnd.classview.model.ClassNode;
import org.netbeans.modules.cnd.classview.model.EnumNode;
import org.netbeans.modules.cnd.classview.model.EnumeratorNode;
import org.netbeans.modules.cnd.classview.model.ForwardClassNode;
import org.netbeans.modules.cnd.classview.model.FriendClassNode;
import org.netbeans.modules.cnd.classview.model.FriendFunctionNode;
import org.netbeans.modules.cnd.classview.model.GlobalFuncNode;
import org.netbeans.modules.cnd.classview.model.MemberNode;
import org.netbeans.modules.cnd.classview.model.ObjectNode;
import org.netbeans.modules.cnd.classview.model.TypedefNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ClassifierKeyArray
extends HostKeyArray
implements UpdatebleHost {
    private static final boolean traceEvents = Boolean.getBoolean("cnd.classview.key-events");

    public ClassifierKeyArray(ChildrenUpdater childrenUpdater, CsmCompoundClassifier classifier) {
        super(childrenUpdater, classifier.getContainingFile().getProject(), PersistentKey.createKey(classifier));
    }

    public ClassifierKeyArray(ChildrenUpdater childrenUpdater, CsmTypedef typedef, CsmCompoundClassifier classifier) {
        super(childrenUpdater, classifier.getContainingFile().getProject(), PersistentKey.createKey(typedef));
    }

    public ClassifierKeyArray(ChildrenUpdater childrenUpdater, CsmClassForwardDeclaration fd, CsmCompoundClassifier classifier) {
        super(childrenUpdater, classifier.getContainingFile().getProject(), PersistentKey.createKey(fd));
    }

    @Override
    public boolean newNamespsce(CsmNamespace ns) {
        return false;
    }

    @Override
    public boolean removeNamespsce(CsmNamespace ns) {
        return false;
    }

    @Override
    protected boolean canCreateNode(CsmOffsetableDeclaration d) {
        return true;
    }

    @Override
    protected Map<PersistentKey, SortedName> getMembers() {
        HashMap<PersistentKey, SortedName> res = new HashMap<PersistentKey, SortedName>();
        try {
            CsmCompoundClassifier classifier = this.getClassifier();
            if (classifier != null) {
                if (CsmKindUtilities.isClass((CsmObject)classifier)) {
                    this.initClass((CsmClass)classifier, res);
                } else if (CsmKindUtilities.isEnum((CsmObject)classifier)) {
                    this.initEnum((CsmEnum)classifier, res);
                }
            }
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    private void initClass(CsmClass cls, Map<PersistentKey, SortedName> res) {
        PersistentKey key;
        for (CsmMember member : cls.getMembers()) {
            key = PersistentKey.createKey(member);
            if (key == null) continue;
            res.put(key, this.getSortedName((CsmOffsetableDeclaration)member));
        }
        for (CsmFriend friend : cls.getFriends()) {
            key = PersistentKey.createKey(friend);
            if (key == null) continue;
            res.put(key, this.getSortedName((CsmOffsetableDeclaration)friend));
        }
    }

    private void initEnum(CsmEnum en, Map<PersistentKey, SortedName> res) {
        for (CsmEnumerator val : en.getEnumerators()) {
            PersistentKey key = PersistentKey.createKey(val);
            if (key == null) continue;
            res.put(key, new SortedName(0, val.getName(), 0));
        }
    }

    private CsmCompoundClassifier getClassifier() {
        CsmClassForwardDeclaration fd;
        CsmClass cls;
        Object object = this.getHostId().getObject();
        if (object instanceof CsmCompoundClassifier) {
            return (CsmCompoundClassifier)object;
        }
        if (CsmKindUtilities.isCsmObject((Object)object) && CsmKindUtilities.isTypedef((CsmObject)((CsmObject)object))) {
            CsmTypedef def = (CsmTypedef)object;
            CsmType type = def.getType();
            if (type != null) {
                return (CsmCompoundClassifier)type.getClassifier();
            }
        } else if (CsmKindUtilities.isCsmObject((Object)object) && CsmKindUtilities.isClassForwardDeclaration((CsmObject)((CsmObject)object)) && (cls = (fd = (CsmClassForwardDeclaration)object).getCsmClass()) != null) {
            return cls;
        }
        return null;
    }

    @Override
    protected CsmOffsetableDeclaration findDeclaration(PersistentKey declId) {
        CsmOffsetableDeclaration res = (CsmOffsetableDeclaration)declId.getObject();
        return res;
    }

    @Override
    protected Node createNode(PersistentKey key) {
        ChildrenUpdater updater = this.getUpdater();
        ObjectNode node = null;
        if (updater != null) {
            try {
                CsmOffsetableDeclaration member = this.findDeclaration(key);
                if (member != null) {
                    if (CsmKindUtilities.isClass((CsmObject)member)) {
                        node = new ClassNode((CsmClass)member, (Children.Array)new ClassifierKeyArray(updater, (CsmCompoundClassifier)((CsmClass)member)));
                    } else if (CsmKindUtilities.isEnum((CsmObject)member)) {
                        node = new EnumNode((CsmEnum)member, (Children.Array)new ClassifierKeyArray(updater, (CsmCompoundClassifier)((CsmEnum)member)));
                    } else if (CsmKindUtilities.isEnumerator((Object)member)) {
                        node = new EnumeratorNode((CsmEnumerator)member);
                    } else if (CsmKindUtilities.isFriendClass((CsmObject)member)) {
                        node = new FriendClassNode((CsmFriendClass)member);
                    } else if (CsmKindUtilities.isFriendMethod((CsmObject)member)) {
                        node = new FriendFunctionNode((CsmFriendFunction)member);
                    } else if (CsmKindUtilities.isTypedef((CsmObject)member)) {
                        CsmClassifier cls;
                        CsmTypedef def = (CsmTypedef)member;
                        if (def.isTypeUnnamed() && (cls = def.getType().getClassifier()) != null && cls.getName().length() == 0 && cls instanceof CsmCompoundClassifier) {
                            return new TypedefNode(def, (Children.Array)new ClassifierKeyArray(updater, def, (CsmCompoundClassifier)cls));
                        }
                        node = new MemberNode((CsmMember)member);
                    } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)member)) {
                        CsmClassForwardDeclaration fd = (CsmClassForwardDeclaration)member;
                        CsmClass csmClass = fd.getCsmClass();
                        node = csmClass != null ? (CsmClassifierResolver.getDefault().isForwardClass((CsmObject)csmClass) ? new ForwardClassNode(fd, Children.LEAF) : new ForwardClassNode(fd, (Children)new ClassifierKeyArray(updater, fd, (CsmCompoundClassifier)csmClass))) : new MemberNode((CsmMember)member);
                    } else if (CsmKindUtilities.isClassMember((CsmObject)member)) {
                        node = new MemberNode((CsmMember)member);
                    } else if (CsmKindUtilities.isFunction((CsmObject)member)) {
                        if (traceEvents) {
                            System.out.println("It should be member:" + member.getUniqueName());
                        }
                        node = new GlobalFuncNode((CsmFunction)member);
                    } else if (traceEvents) {
                        System.out.println("It should be member:" + member.getUniqueName());
                    }
                }
            }
            catch (AssertionError ex) {
                ((Throwable)((Object)ex)).printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return node;
    }
}

