/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OutputPattern {
    public final Pattern pattern;
    public final Order order;
    public final String name;

    public OutputPattern(String name, Pattern pattern, Order order) {
        this.name = name;
        this.pattern = pattern;
        this.order = order;
    }

    public boolean match(String line) {
        Matcher m = this.pattern.matcher(line);
        return m.matches() && m.groupCount() == 2;
    }

    public MatchResult process(String line) {
        Matcher m = this.pattern.matcher(line);
        if (m.matches() && m.groupCount() == 2) {
            try {
                int l = Integer.parseInt(m.group(this.order == Order.FILE_LINE ? 2 : 1));
                String file = m.group(this.order == Order.FILE_LINE ? 1 : 2);
                return new MatchResult(file, l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static enum Order {
        FILE_LINE,
        LINE_FILE;

    }

    public static class MatchResult {
        public final String filePath;
        public final int line;

        public MatchResult(String filePath, int line) {
            this.filePath = filePath;
            this.line = line;
        }
    }
}

