/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import com.ibm.icu.lang.UCharacter;
import java.util.Arrays;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public final class KeyLabelList
extends AbstractDatatype {
    public static final KeyLabelList THE_INSTANCE = new KeyLabelList();

    private KeyLabelList() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        Object[] keylabels = literal.toString().split("\\s+");
        Arrays.sort(keylabels);
        for (int i = 0; i < keylabels.length; ++i) {
            char[] chars;
            Object label = keylabels[i];
            if (i > 0 && ((String)label).equals(keylabels[i - 1])) {
                throw this.newDatatypeException("Duplicate key label. Each key label must be unique.");
            }
            if (!(((String)label).length() != 2 || UCharacter.isHighSurrogate((char)(chars = ((String)label).toCharArray())[0]) && UCharacter.isLowSurrogate((char)chars[1]))) {
                throw this.newDatatypeException("Key label has multiple characters. Each key label must be a single character.");
            }
            if (((String)label).length() <= 2) continue;
            throw this.newDatatypeException("Key label has multiple characters. Each key label must be a single character.");
        }
    }

    @Override
    public String getName() {
        return "key label list";
    }
}

