/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.frontend.DependencyOutputOptions;
import org.clang.frontend.impl.DependencyFileStatics;
import org.clang.lex.PPCallbacks;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.stdimpl.aliases.StdVectorString;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.Twine;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class DFGImpl
extends PPCallbacks
implements Destructors.ClassWithDestructor {
    private std.vectorString Files = new std.vectorString(std.string.EMPTY);
    private StringSet FilesSet = new StringSet();
    private Preprocessor PP;
    private std.string OutputFile;
    private std.vectorString Targets;
    private boolean IncludeSystemHeaders;
    private boolean PhonyTarget;
    private boolean AddMissingHeaderDeps;
    private boolean SeenMissingHeader;
    private boolean IncludeModuleFiles;

    private boolean FileMatchesDepCriteria(char.ptr Filename, SrcMgr.CharacteristicKind FileType) {
        if (DependencyFileStatics.isSpecialFilename(new StringRef(Filename))) {
            return false;
        }
        if (this.IncludeSystemHeaders) {
            return true;
        }
        return FileType == SrcMgr.CharacteristicKind.C_User;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OutputDependencyFile() {
        raw_fd_ostream OS = null;
        try {
            int N;
            if (this.SeenMissingHeader) {
                fs.remove((Twine)new Twine(this.OutputFile));
                return;
            }
            std_errors.error_code EC = new std_errors.error_code();
            OS = new raw_fd_ostream(new StringRef(this.OutputFile), EC, 4);
            if (EC.$bool()) {
                BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.PP.getDiagnostics().Report(508), (StringRef)new StringRef(this.OutputFile)), (StringRef)new StringRef(EC.message())).$destroy();
                return;
            }
            int MaxColumns = 75;
            int Columns = 0;
            StdVectorString.iterator I = this.Targets.begin();
            StdVectorString.iterator E = this.Targets.end();
            while (std.$noteq___normal_iterator((StdVectorString.iterator)I, (StdVectorString.iterator)E)) {
                N = I.$arrow().length();
                if (Columns == 0) {
                    Columns += N;
                } else if (Columns + N + 2 > MaxColumns) {
                    Columns = N + 2;
                    OS.$out(NativePointer.$((String)" \\\n  "));
                } else {
                    Columns += N + 1;
                    OS.$out_char(NativePointer.$((char)' '));
                }
                OS.$out(I.$star());
                I.$preInc();
            }
            OS.$out_char(NativePointer.$((char)':'));
            ++Columns;
            I = this.Files.begin();
            E = this.Files.end();
            while (std.$noteq___normal_iterator((StdVectorString.iterator)I, (StdVectorString.iterator)E)) {
                N = I.$arrow().length();
                if (Columns + (N + 1) + 2 > MaxColumns) {
                    OS.$out(NativePointer.$((String)" \\\n "));
                    Columns = 2;
                }
                OS.$out_char(NativePointer.$((char)' '));
                DependencyFileStatics.PrintFilename((raw_ostream)OS, new StringRef(I.$star()));
                Columns += N + 1;
                I.$preInc();
            }
            OS.$out_char(NativePointer.$((char)'\n'));
            if (this.PhonyTarget && !this.Files.empty()) {
                I = this.Files.begin().$preInc();
                E = this.Files.end();
                while (std.$noteq___normal_iterator((StdVectorString.iterator)I, (StdVectorString.iterator)E)) {
                    OS.$out_char(NativePointer.$((char)'\n'));
                    DependencyFileStatics.PrintFilename((raw_ostream)OS, new StringRef(I.$star()));
                    OS.$out(NativePointer.$((String)":\n"));
                    I.$preInc();
                }
            }
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
        }
    }

    public DFGImpl(Preprocessor _PP, DependencyOutputOptions Opts) {
        this.PP = _PP;
        this.OutputFile = new std.string(Opts.OutputFile);
        this.Targets = new std.vectorString(Opts.Targets);
        this.IncludeSystemHeaders = Opts.IncludeSystemHeaders;
        this.PhonyTarget = Opts.UsePhonyTargets;
        this.AddMissingHeaderDeps = Opts.AddMissingHeaderDeps;
        this.SeenMissingHeader = false;
        this.IncludeModuleFiles = Opts.IncludeModuleFiles;
    }

    public void FileChanged(SourceLocation Loc, PPCallbacks.FileChangeReason Reason, SrcMgr.CharacteristicKind FileType, FileID PrevFID) {
        if (Reason != PPCallbacks.FileChangeReason.EnterFile) {
            return;
        }
        SourceManager SM = this.PP.getSourceManager();
        FileEntry FE = SM.getFileEntryForID(SM.getFileID(SM.getExpansionLoc(new SourceLocation(Loc))));
        if (FE == null) {
            return;
        }
        StringRef Filename = new StringRef(FE.getName());
        if (!this.FileMatchesDepCriteria(Filename.data(), FileType)) {
            return;
        }
        while (Filename.size() > 2 && Filename.$at(0) == NativePointer.$((char)'.') && path.is_separator((byte)Filename.$at(1))) {
            Filename.$assign$substr(1);
            while (path.is_separator((byte)Filename.$at(0))) {
                Filename.$assign$substr(1);
            }
        }
        this.AddFilename(new StringRef(Filename));
    }

    public void InclusionDirective(SourceLocation HashLoc, SourceLocation EodLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange, FileEntry File2, StringRef SearchPath, StringRef RelativePath, Module Imported) {
        if (File2 == null) {
            if (this.AddMissingHeaderDeps) {
                this.AddFilename(new StringRef(FileName));
            } else {
                this.SeenMissingHeader = true;
            }
        }
    }

    public void EndOfMainFile() {
        this.OutputDependencyFile();
    }

    public void AddFilename(StringRef Filename) {
        if (this.FilesSet.insert((StringRef)new StringRef((StringRef)Filename)).second) {
            this.Files.push_back(Filename.$basic_string());
        }
    }

    public boolean includeSystemHeaders() {
        return this.IncludeSystemHeaders;
    }

    public boolean includeModuleFiles() {
        return this.IncludeModuleFiles;
    }

    public void $destroy() {
        this.Targets.$destroy();
        this.OutputFile.$destroy();
        this.FilesSet.$destroy();
        this.Files.$destroy();
        super.$destroy();
    }

    public String toString() {
        return "Files=" + this.Files + ", FilesSet=" + this.FilesSet + ", OutputFile=" + this.OutputFile + ", Targets=" + this.Targets + ", IncludeSystemHeaders=" + this.IncludeSystemHeaders + ", PhonyTarget=" + this.PhonyTarget + ", AddMissingHeaderDeps=" + this.AddMissingHeaderDeps + ", SeenMissingHeader=" + this.SeenMissingHeader + ", IncludeModuleFiles=" + this.IncludeModuleFiles + super.toString();
    }
}

