/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.diff.ExportAsFilePanel;
import org.netbeans.modules.mercurial.remote.ui.diff.ExportBundleAction;
import org.netbeans.modules.mercurial.remote.ui.diff.ExportBundlePanel;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.ExportDiffSupport;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ExportBundle
extends ExportDiffSupport
implements ActionListener,
PropertyChangeListener {
    private final ExportBundlePanel panel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final VCSFileProxy repository;
    private ExportAsFilePanel targetPanel;
    private DialogDescriptor dialogDescriptor;
    private final String HG_TIP = "tip";
    private final String HG_NULL_BASE = "null";
    private final ChangesetPickerSimplePanel changesetPickerPanel;
    private static final HashMap<String, String> resourceNames = new HashMap();
    private static final String SEP = " ";
    private final JButton selectButton;

    public ExportBundle(VCSFileProxy repository) {
        super(new VCSFileProxy[]{repository}, HgModuleConfig.getDefault(repository).getPreferences());
        this.repository = repository;
        this.panel = new ExportBundlePanel(repository);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundleDialog_Action_Export"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportBundle.class, (String)"ACSD_ExportBundleDialog_Action_Export"));
        this.okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportBundle.class, (String)"ACSN_ExportBundleDialog_Action_Export"));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundleDialog_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportBundle.class, (String)"ACSD_ExportBundleDialog_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportBundle.class, (String)"ACSN_ExportBundleDialog_Action_Cancel"));
        this.panel.baseRevision.setModel(new DefaultComboBoxModel<String>(new String[]{"tip", "null"}));
        this.panel.baseRevision.setSelectedIndex(0);
        this.panel.txtTopRevision.setText("tip");
        this.panel.addActionListener(this);
        this.selectButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.selectButton, (String)NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundle.ChangesetPicker_SelectButton"));
        this.changesetPickerPanel = new ChangesetPickerSimplePanel(repository);
    }

    protected ExportDiffSupport.AbstractExportDiffPanel createSimpleDialog(String currentFilePath) {
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundleDialog_Title"), true, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass()), null);
        this.targetPanel = new ExportAsFilePanel();
        this.targetPanel.addOutputFileTextDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportBundle.this.nameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportBundle.this.nameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportBundle.this.nameChange();
            }
        });
        this.panel.setInsidePanel(this.targetPanel);
        return this.targetPanel;
    }

    protected void createComplexDialog(ExportDiffSupport.AbstractExportDiffPanel insidePanel) {
        this.panel.setInsidePanel(insidePanel);
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundleDialog_Title"));
    }

    protected VCSFileProxy createTempFile() throws IOException {
        return VCSFileProxySupport.createTempFile((VCSFileProxy)this.repository, (String)"hg-bundle", (String)".hg", (boolean)false);
    }

    protected String getMessage(String resourceName) {
        String translatedResourceName = resourceNames.get(resourceName);
        if (translatedResourceName == null) {
            return super.getMessage(resourceName);
        }
        return NbBundle.getMessage(ExportBundle.class, (String)translatedResourceName);
    }

    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("hg") || f.getName().endsWith("bundle") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundle_FileMask");
            }
        };
    }

    protected VCSFileProxy getTargetFile(VCSFileProxy target) {
        String name = target.getName();
        boolean requiredExt = false;
        requiredExt |= name.endsWith(".hg");
        if (!(requiredExt |= name.endsWith(".bundle"))) {
            VCSFileProxy parent = target.getParentFile();
            target = VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)(name + ".hg"));
        }
        return target;
    }

    private void nameChange() {
        if (!this.targetPanel.getOutputFileText().trim().isEmpty()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private String getBaseRevision() {
        String rev = this.panel.getSelectedBaseRevision();
        if (rev == null) {
            rev = "null";
        }
        return ExportBundle.parseRevision(rev);
    }

    private String getTopRevision() {
        String rev = this.panel.getSelectedRevision();
        if (rev == null) {
            rev = "tip";
        }
        return ExportBundle.parseRevision(rev);
    }

    private static String parseRevision(String revision) {
        int pos = revision.indexOf(SEP);
        if (pos > 0) {
            revision = revision.substring(0, pos);
        }
        return revision;
    }

    public void writeDiffFile(final VCSFileProxy toFile) {
        HgProgressSupport supp = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                String revBase = ExportBundle.this.getBaseRevision();
                String revTo = ExportBundle.this.getTopRevision();
                OutputLogger logger = this.getLogger();
                if (toFile.getParentFile() != null) {
                    HgModuleConfig.getDefault(ExportBundle.this.repository).getPreferences().put("ExportDiff.saveFolder", toFile.getParentFile().getPath());
                }
                try {
                    logger.outputInRed(NbBundle.getMessage(ExportBundleAction.class, (String)"MSG_EXPORT_BUNDLE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(ExportBundleAction.class, (String)"MSG_EXPORT_BUNDLE_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(ExportBundleAction.class, (String)"MSG_EXPORT_BUNDLE_PROGRESS", (Object[])new String[]{revTo, revBase, toFile.getPath()}));
                    List<String> list = HgCommand.doBundle(ExportBundle.this.repository, revBase, revTo, toFile, logger);
                    logger.output(list);
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    logger.outputInRed(NbBundle.getMessage(ExportBundleAction.class, (String)"MSG_EXPORT_BUNDLE_DONE"));
                    logger.output("");
                }
            }
        };
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(this.repository);
        supp.start(rp, this.repository, NbBundle.getMessage(ExportBundleAction.class, (String)"LBL_ExportBundle_Progress")).waitFinished();
    }

    protected DialogDescriptor getDialogDescriptor() {
        return this.dialogDescriptor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        DialogDescriptor dd = new DialogDescriptor((Object)this.changesetPickerPanel, NbBundle.getMessage(ExportBundle.class, (String)"CTL_ExportBundle.ChangesetPicker_Title"), true, new Object[]{this.selectButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.selectButton, 0, new HelpCtx("org.netbeans.modules.mercurial.remote.ui.repository.ChangesetPickerPanel"), null);
        this.selectButton.setEnabled(this.changesetPickerPanel.getSelectedRevision() != null);
        this.changesetPickerPanel.addPropertyChangeListener(this);
        this.changesetPickerPanel.initRevisions();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        this.changesetPickerPanel.removePropertyChangeListener(this);
        if (dd.getValue() == this.selectButton) {
            String revision;
            HgLogMessage revisionWithChangeset = this.changesetPickerPanel.getSelectedRevision();
            String string = revision = "tip".equals(revisionWithChangeset.getRevisionNumber()) ? "tip" : revisionWithChangeset.getRevisionNumber() + SEP + "(" + revisionWithChangeset.getCSetShortID() + ")";
            if ("command.selectBaseRevision".equals(command)) {
                this.panel.baseRevision.setModel(new DefaultComboBoxModel<String>(new String[]{"null", revision}));
                this.panel.baseRevision.setSelectedItem(revision);
            } else if ("command.selectRevision".equals(command)) {
                this.panel.txtTopRevision.setText(revision);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.selectButton != null && "prop.valid".equals(evt.getPropertyName())) {
            boolean valid = (Boolean)evt.getNewValue();
            this.selectButton.setEnabled(valid);
        }
    }

    static {
        resourceNames.put("CTL_Attaching", "CTL_Attaching");
        resourceNames.put("CTL_Export_Title", "CTL_ExportBundleDialog_Title");
    }

    private static class ChangesetPickerSimplePanel
    extends ChangesetPickerPanel {
        private boolean initialized;

        public ChangesetPickerSimplePanel(VCSFileProxy repository) {
            super(repository, null);
            this.initComponents();
        }

        @Override
        protected String getRefreshLabel() {
            return NbBundle.getMessage(ExportBundle.class, (String)"MSG_Fetching_Revisions");
        }

        private void initRevisions() {
            if (!this.initialized) {
                this.initialized = true;
                this.loadRevisions();
            }
        }

        private void initComponents() {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ExportBundle.class, (String)"ExportBundle.ChangesetPicker.jLabel1.text"));
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ExportBundle.class, (String)"LBL_EXPORT_INFO"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportBundle.class, (String)"ExportBundle.ChangesetPicker.AccessibleContext.accessibleDescription"));
        }
    }
}

