/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.spi.J2SEPlatformDefaultJavadoc;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

public final class JavaFxDefaultJavadocImpl
implements J2SEPlatformDefaultJavadoc {
    private static final Map<SpecificationVersion, String> OFFICIAL_JAVADOC;

    @NonNull
    public Collection<URI> getDefaultJavadoc(@NonNull JavaPlatform platform) {
        ArrayList<? extends URI> result = new ArrayList<URI>();
        JavadocFilter filter = new JavadocFilter();
        for (FileObject installFolder : platform.getInstallFolders()) {
            for (FileObject file : installFolder.getChildren()) {
                Collection<? extends URI> roots = filter.accept(file);
                result.addAll(roots);
            }
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableCollection(result);
        }
        SpecificationVersion spec = platform.getSpecification().getVersion();
        String uri = OFFICIAL_JAVADOC.get(spec);
        if (uri != null) {
            try {
                return Collections.singletonList(new URI(uri));
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return Collections.emptyList();
    }

    static {
        HashMap<SpecificationVersion, String> jdocs = new HashMap<SpecificationVersion, String>();
        jdocs.put(new SpecificationVersion("1.7"), "https://docs.oracle.com/javafx/2/api/");
        jdocs.put(new SpecificationVersion("1.8"), "https://docs.oracle.com/javase/8/javafx/api/");
        OFFICIAL_JAVADOC = Collections.unmodifiableMap(jdocs);
    }

    private static final class JavadocFilter {
        private static final Pattern DOCS_FILE_PATTERN = Pattern.compile(".*docs.*\\.(zip|jar)", 2);
        private static final Pattern JAVAFX_FILE_PATTERN = Pattern.compile(".*j(ava)?fx.*", 2);
        private static final Collection<String> DOCS_PATHS;

        private JavadocFilter() {
        }

        @NonNull
        Collection<? extends URI> accept(@NonNull FileObject fo) {
            FileObject root;
            String nameExt;
            if (fo.canRead() && fo.isData() && DOCS_FILE_PATTERN.matcher(nameExt = fo.getNameExt()).matches() && JAVAFX_FILE_PATTERN.matcher(nameExt).matches() && (root = FileUtil.getArchiveRoot((FileObject)fo)) != null) {
                ArrayList<URI> roots = new ArrayList<URI>(DOCS_PATHS.size());
                for (String path : DOCS_PATHS) {
                    FileObject docRoot = root.getFileObject(path);
                    if (docRoot == null) continue;
                    roots.add(docRoot.toURI());
                }
                return Collections.unmodifiableCollection(roots);
            }
            return Collections.emptySet();
        }

        static {
            ArrayList<String> paths = new ArrayList<String>(3);
            paths.add("api/");
            DOCS_PATHS = Collections.unmodifiableList(paths);
        }
    }
}

