/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.File;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public class WLSharedState {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private DomainChangeListener domainListener;
    private boolean restartNeeded;

    public synchronized void configure(InstanceProperties ip) {
        if (this.domainListener != null) {
            return;
        }
        File domainConfig = WLPluginProperties.getDomainConfigFile(ip);
        if (domainConfig != null) {
            this.domainListener = new DomainChangeListener();
            FileUtil.addFileChangeListener((FileChangeListener)this.domainListener, (File)domainConfig);
        }
    }

    public void addDomainChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeDomainChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public synchronized boolean isRestartNeeded() {
        return this.restartNeeded;
    }

    public synchronized void setRestartNeeded(boolean restartNeeded) {
        this.restartNeeded = restartNeeded;
    }

    private class DomainChangeListener
    implements FileChangeListener {
        private DomainChangeListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            WLSharedState.this.changeSupport.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
            WLSharedState.this.changeSupport.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            WLSharedState.this.changeSupport.fireChange();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
            WLSharedState.this.changeSupport.fireChange();
        }
    }
}

