/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.EnumImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public final class EnumeratorImpl
extends OffsetableDeclarationBase<CsmEnumerator>
implements CsmEnumerator {
    private final CharSequence name;
    private CsmEnum enumerationRef;
    private final CsmUID<CsmEnum> enumerationUID;

    private EnumeratorImpl(CsmFile file, AST ast, NameHolder name, EnumImpl enumeration) {
        super(file, EnumeratorImpl.getStartOffset(ast), EnumeratorImpl.getEndOffset(ast));
        assert (enumeration != null);
        this.name = NameCache.getManager().getString(name.getName());
        this.enumerationUID = UIDCsmConverter.declarationToUID(enumeration);
        assert (this.enumerationUID != null);
        this.enumerationRef = null;
    }

    public static EnumeratorImpl create(AST ast, CsmFile file, FileContent fileContent, EnumImpl enumeration, boolean global) {
        NameHolder holder = NameHolder.createSimpleName(ast);
        EnumeratorImpl ei = new EnumeratorImpl(file, ast, holder, enumeration);
        EnumeratorImpl.postObjectCreateRegistration(global, ei);
        holder.addReference(fileContent, ei);
        return ei;
    }

    private EnumeratorImpl(EnumImpl enumeration, CharSequence name, CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
        assert (enumeration != null);
        this.name = NameCache.getManager().getString(name);
        this.enumerationUID = UIDCsmConverter.declarationToUID(enumeration);
        assert (this.enumerationUID != null);
        this.enumerationRef = null;
    }

    public static EnumeratorImpl create(EnumImpl enumeration, String name, int startOffset, int endOffset, boolean global) {
        EnumeratorImpl ei = new EnumeratorImpl(enumeration, name, enumeration.getContainingFile(), startOffset, endOffset);
        EnumeratorImpl.postObjectCreateRegistration(global, ei);
        return ei;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmExpression getExplicitValue() {
        return null;
    }

    public CsmEnum getEnumeration() {
        return this._getEnumeration();
    }

    public CsmScope getScope() {
        return this.getEnumeration();
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.ENUMERATOR;
    }

    public CharSequence getQualifiedName() {
        CsmEnum e = this._getEnumeration();
        if (e == null) {
            return CharSequences.create((CharSequence)this.getQualifiedNamePostfix());
        }
        return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)e.getQualifiedName(), (CharSequence)"::", (CharSequence)this.getQualifiedNamePostfix()));
    }

    private synchronized CsmEnum _getEnumeration() {
        CsmEnum enumeration = this.enumerationRef;
        if (enumeration == null) {
            enumeration = UIDCsmConverter.UIDtoDeclaration(this.enumerationUID);
            assert (enumeration != null || this.enumerationUID == null) : "null object for UID " + this.enumerationUID;
        }
        return enumeration;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.enumerationRef == null) {
            this.enumerationRef = UIDCsmConverter.UIDtoDeclaration(this.enumerationUID);
            assert (this.enumerationRef != null || this.enumerationUID == null) : "no object for UID " + this.enumerationUID;
        }
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        assert (this.enumerationUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.enumerationUID, output);
    }

    public EnumeratorImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        this.enumerationUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        assert (this.enumerationUID != null);
        this.enumerationRef = null;
    }

    public static class EnumeratorBuilder {
        private CharSequence name;
        private CsmFile file;
        private int startOffset;
        private int endOffset;
        private EnumImpl enumeration;
        private final FileContent fileContent;

        public EnumeratorBuilder(FileContent fileContent) {
            this.fileContent = fileContent;
        }

        public void setName(CharSequence name) {
            this.name = name;
        }

        public void setFile(CsmFile file) {
            this.file = file;
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        public void setEnum(EnumImpl enumeration) {
            this.enumeration = enumeration;
        }

        public EnumeratorImpl create(boolean register) {
            if (this.name != null) {
                NameHolder nameHolder = NameHolder.createName(this.name, this.startOffset, this.endOffset);
                EnumeratorImpl impl = new EnumeratorImpl(this.enumeration, this.name, this.file, this.startOffset, this.endOffset);
                EnumeratorImpl.postObjectCreateRegistration(register, impl);
                nameHolder.addReference(this.fileContent, impl);
                return impl;
            }
            return null;
        }
    }
}

