/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.ArmStatics;
import org.clang.driver.tools.impl.GnuTool;
import org.clang.driver.tools.impl.MipsStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public final class NetbsdStatics {

    public static class Linker
    extends GnuTool
    implements Destructors.ClassWithDestructor {
        public Linker(ToolChain TC) {
            super(NativePointer.$((String)"netbsd::Linker"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Driver D = this.getToolChain().getDriver();
                ArgStringList CmdArgs = new ArgStringList();
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string$C((String)"--sysroot=", (std.string)D.SysRoot))));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                } else {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bshareable"));
                    } else {
                        Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_pie.getValue()));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"/libexec/ld.elf_so"));
                    }
                }
                block1 : switch (this.getToolChain().getArch()) {
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf_i386"));
                        break;
                    }
                    case arm: 
                    case thumb: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        switch (this.getToolChain().getTriple().getEnvironment()) {
                            case EABI: 
                            case GNUEABI: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"armelf_nbsd_eabi"));
                                break block1;
                            }
                            case EABIHF: 
                            case GNUEABIHF: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"armelf_nbsd_eabihf"));
                                break block1;
                            }
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"armelf_nbsd"));
                        break;
                    }
                    case armeb: 
                    case thumbeb: {
                        ArmStatics.appendEBLinkFlags(Args, CmdArgs, new Triple(new Twine(this.getToolChain().ComputeEffectiveClangTriple(Args))));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        switch (this.getToolChain().getTriple().getEnvironment()) {
                            case EABI: 
                            case GNUEABI: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"armelfb_nbsd_eabi"));
                                break block1;
                            }
                            case EABIHF: 
                            case GNUEABIHF: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"armelfb_nbsd_eabihf"));
                                break block1;
                            }
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"armelfb_nbsd"));
                        break;
                    }
                    case mips64: 
                    case mips64el: {
                        if (MipsStatics.hasMipsAbiArg(Args, NativePointer.$((String)"32"))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                            if (this.getToolChain().getArch() == Triple.ArchType.mips64) {
                                CmdArgs.push_back((Object)NativePointer.$((String)"elf32btsmip"));
                                break;
                            }
                            CmdArgs.push_back((Object)NativePointer.$((String)"elf32ltsmip"));
                            break;
                        }
                        if (!MipsStatics.hasMipsAbiArg(Args, NativePointer.$((String)"64"))) break;
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        if (this.getToolChain().getArch() == Triple.ArchType.mips64) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"elf64btsmip"));
                            break;
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf64ltsmip"));
                        break;
                    }
                    case ppc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf32ppc_nbsd"));
                        break;
                    }
                    case ppc64: 
                    case ppc64le: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf64ppc"));
                        break;
                    }
                    case sparc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf32_sparc"));
                        break;
                    }
                    case sparcv9: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf64_sparc"));
                        break;
                    }
                }
                if (Output.isFilename()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                    CmdArgs.push_back((Object)Output.getFilename());
                } else assert (Output.isNothing()) : "Invalid output.";
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crt0.o")))));
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crti.o")))));
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtbeginS.o")))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtbegin.o")))));
                    }
                }
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_L.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_T_Group.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_e.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_s.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_t.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_Z_Flag.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_r.getValue()));
                ToolsStatics.AddLinkerInputs(this.getToolChain(), Inputs, Args, CmdArgs);
                uint.ref Major = NativePointer.create_uint$ref();
                uint.ref Minor = NativePointer.create_uint$ref();
                uint.ref Micro = NativePointer.create_uint$ref();
                this.getToolChain().getTriple().getOSVersion(Major, Minor, Micro);
                boolean useLibgcc = true;
                if (Unsigned.$greatereq_uint((uint.ref)Major, (int)7) || Major.$deref() == 0) {
                    switch (this.getToolChain().getArch()) {
                        case x86: 
                        case arm: 
                        case armeb: 
                        case thumb: 
                        case thumbeb: 
                        case sparc: 
                        case sparcv9: 
                        case ppc: 
                        case ppc64: 
                        case ppc64le: 
                        case aarch64: 
                        case x86_64: {
                            useLibgcc = false;
                            break;
                        }
                    }
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    ToolsStatics.addOpenMPRuntime(CmdArgs, this.getToolChain(), Args);
                    if (D.CCCIsCXX()) {
                        this.getToolChain().AddCXXStdlibLibArgs(Args, CmdArgs);
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_pthread.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                    if (useLibgcc) {
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                        }
                    }
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtendS.o")))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtend.o")))));
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().GetFilePath(NativePointer.$((String)"crtn.o")))));
                }
                this.getToolChain().addProfileRTLibs(Args, CmdArgs);
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetLinkerPath())));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assembler
    extends GnuTool
    implements Destructors.ClassWithDestructor {
        public Assembler(ToolChain TC) {
            super(NativePointer.$((String)"netbsd::Assembler"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                ArgStringList CmdArgs = new ArgStringList();
                switch (this.getToolChain().getArch()) {
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                        break;
                    }
                    case arm: 
                    case armeb: 
                    case thumb: 
                    case thumbeb: {
                        StringRef MArch = new StringRef();
                        StringRef MCPU = new StringRef();
                        ToolsStatics.getARMArchCPUFromArgs(Args, MArch, MCPU, true);
                        std.string Arch = ArmStatics.getARMTargetCPU(new StringRef(MCPU), new StringRef(MArch), this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string$C((String)"-mcpu=", (std.string)Arch))));
                        break;
                    }
                    case mips: 
                    case mipsel: 
                    case mips64: 
                    case mips64el: {
                        StringRef CPUName = new StringRef();
                        StringRef ABIName = new StringRef();
                        MipsStatics.getMipsCPUAndABI(Args, this.getToolChain().getTriple(), CPUName, ABIName);
                        CmdArgs.push_back((Object)NativePointer.$((String)"-march"));
                        CmdArgs.push_back((Object)CPUName.data());
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mabi"));
                        CmdArgs.push_back((Object)ToolsStatics.getGnuCompatibleMipsABIName(ABIName).data());
                        if (this.getToolChain().getArch() == Triple.ArchType.mips || this.getToolChain().getArch() == Triple.ArchType.mips64) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                        }
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                    case sparc: 
                    case sparcel: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-32"));
                        Object CPU = ToolsStatics.getCPUName(Args, this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)ToolsStatics.getSparcAsmModeForCPU(new StringRef((std.string)CPU), this.getToolChain().getTriple()));
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                    case sparcv9: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-64"));
                        Object CPU = ToolsStatics.getCPUName(Args, this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)ToolsStatics.getSparcAsmModeForCPU(new StringRef((std.string)CPU), this.getToolChain().getTriple()));
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                }
                Args.AddAllArgValues(CmdArgs, new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"as")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

