/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory2;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentFactory;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.config.CarDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.EarDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.EjbDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;

public class JBModuleConfigurationFactory
implements ModuleConfigurationFactory2 {
    public ModuleConfiguration create(J2eeModule j2eeModule) throws ConfigurationException {
        if (J2eeModule.Type.WAR.equals(j2eeModule.getType())) {
            return new WarDeploymentConfiguration(j2eeModule);
        }
        if (J2eeModule.Type.EJB.equals(j2eeModule.getType())) {
            return new EjbDeploymentConfiguration(j2eeModule);
        }
        if (J2eeModule.Type.CAR.equals(j2eeModule.getType())) {
            return new CarDeploymentConfiguration(j2eeModule);
        }
        if (J2eeModule.Type.EAR.equals(j2eeModule.getType())) {
            return new EarDeploymentConfiguration(j2eeModule);
        }
        throw new ConfigurationException("Not supported module: " + j2eeModule.getType());
    }

    public ModuleConfiguration create(J2eeModule j2eeModule, String instanceUrl) throws ConfigurationException {
        if (!instanceUrl.startsWith("jboss-deployer:")) {
            return this.create(j2eeModule);
        }
        try {
            JBDeploymentManager dm = (JBDeploymentManager)JBDeploymentFactory.getInstance().getDisconnectedDeploymentManager(instanceUrl);
            JBPluginUtils.Version version = dm.getProperties().getServerVersion();
            if (J2eeModule.Type.WAR.equals(j2eeModule.getType())) {
                return new WarDeploymentConfiguration(j2eeModule, version);
            }
            if (J2eeModule.Type.EJB.equals(j2eeModule.getType())) {
                return new EjbDeploymentConfiguration(j2eeModule, version);
            }
            if (J2eeModule.Type.EAR.equals(j2eeModule.getType())) {
                return new EarDeploymentConfiguration(j2eeModule, version);
            }
        }
        catch (DeploymentManagerCreationException ex) {
            return this.create(j2eeModule);
        }
        throw new ConfigurationException("Not supported module: " + j2eeModule.getType());
    }
}

