/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.event.ChangeListener;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.php.smarty.editor.TplSyntax;
import org.netbeans.modules.php.smarty.editor.lexer.TplTokenId;
import org.netbeans.modules.php.smarty.editor.parser.TplParserResult;
import org.openide.util.NbBundle;

public class TplParser
extends Parser {
    private TplParserResult result;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sme) throws ParseException {
        this.result = new TplParserResult(snapshot);
        TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
        LanguagePath tplMimePath = null;
        for (LanguagePath path : tokenHierarchy.languagePaths()) {
            if (!path.mimePath().endsWith("x-tpl-inner")) continue;
            tplMimePath = path;
            break;
        }
        if (tplMimePath != null) {
            List tsList = tokenHierarchy.tokenSequenceList(tplMimePath, 0, Integer.MAX_VALUE);
            ArrayList<Section> sectionList = new ArrayList<Section>();
            for (TokenSequence ts : tsList) {
                ts.moveNext();
                Token token = ts.token();
                Section section = new Section();
                int startOffset = ts.offset();
                StringBuilder textBuilder = new StringBuilder();
                if (token.id() == TplTokenId.FUNCTION) {
                    section.function = CharSequenceUtilities.toString((CharSequence)token.text());
                } else {
                    textBuilder.append(token.text());
                }
                while (ts.moveNext()) {
                    token = ts.token();
                    textBuilder.append(token.text());
                }
                int endOffset = startOffset + (startOffset == ts.offset() ? token.length() : ts.offset() - startOffset + token.length());
                section.offsetRange = new OffsetRange(startOffset, endOffset);
                section.text = textBuilder.toString();
                sectionList.add(section);
            }
            Stack<Object> blockStack = new Stack<Object>();
            for (Section section : sectionList) {
                Object block;
                if (section.function == null) {
                    block = new TplParserResult.Block(section.toParserResultSection());
                    this.result.addBlock((TplParserResult.Block)block);
                    continue;
                }
                if (TplSyntax.isEndingSmartyCommand(section.function) || TplSyntax.isElseSmartyCommand(section.function)) {
                    if (blockStack.empty()) {
                        this.result.addError(NbBundle.getMessage(TplParser.class, (String)"ERR_Unopened_Tag", (Object)TplSyntax.getRelatedBaseCommand(section.function)), section.offsetRange.getStart(), section.offsetRange.getLength());
                        continue;
                    }
                    if (TplSyntax.isInRelatedCommand(section.function, ((Block)blockStack.peek()).getControlTag().function)) {
                        if (!TplSyntax.isElseSmartyCommand(section.function)) {
                            block = (Block)blockStack.pop();
                            ((Block)block).sections.add(section);
                            this.result.addBlock(((Block)block).toParserResultBlock());
                            continue;
                        }
                        Block controlTag = (Block)blockStack.peek();
                        controlTag.sections.add(section);
                        continue;
                    }
                    this.result.addError(NbBundle.getMessage(TplParser.class, (String)"ERR_Unexpected_Tag", (Object[])new Object[]{section.function, TplSyntax.getEndingCommand(((Block)blockStack.peek()).getControlTag().function)}), section.offsetRange.getStart(), section.offsetRange.getLength());
                    continue;
                }
                if (TplSyntax.isBlockCommand(section.function)) {
                    block = new Block(section);
                    blockStack.push(block);
                    continue;
                }
                block = new TplParserResult.Block(section.toParserResultSection());
                this.result.addBlock((TplParserResult.Block)block);
            }
            if (!blockStack.empty()) {
                while (!blockStack.empty()) {
                    for (Section section : ((Block)blockStack.pop()).sections) {
                        this.result.addError(NbBundle.getMessage(TplParser.class, (String)"ERR_Unclosed_Tag", (Object)TplSyntax.getRelatedBaseCommand(section.function)), section.offsetRange.getStart(), section.offsetRange.getLength());
                    }
                }
            }
        }
    }

    public Parser.Result getResult(Task task) throws ParseException {
        return this.result;
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    private static class Section {
        private String function = null;
        private OffsetRange offsetRange = new OffsetRange(0, 0);
        private String text;

        private Section() {
        }

        private TplParserResult.Section toParserResultSection() {
            return new TplParserResult.Section(this.function, this.offsetRange, this.text);
        }
    }

    private static class Block {
        private final List<Section> sections = new LinkedList<Section>();

        public Block(Section section) {
            this.sections.add(section);
        }

        private TplParserResult.Block toParserResultBlock() {
            TplParserResult.Block block = new TplParserResult.Block();
            for (Section section : this.sections) {
                block.addSection(section.toParserResultSection());
            }
            return block;
        }

        private Section getControlTag() {
            return this.sections.get(0);
        }
    }

    public static class Factory
    extends ParserFactory {
        public Parser createParser(Collection<Snapshot> clctn) {
            return new TplParser();
        }
    }
}

