/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.classfile.ClassLoaderTable;
import org.netbeans.lib.profiler.classfile.ClassPath;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.utils.FileOrZipEntry;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassFileCache {
    private static ClassFileCache defaultClassFileCache;
    private ClassPath classPath;
    private Hashtable vmSuppliedClassCache;
    private byte[][] classFileBytes;
    private String[] classNameAndLocation;
    private long[] lastTimeUsed;
    private int capacity = 877;
    private int size = 0;
    private int sizeLimit = this.capacity * 3 / 4;
    private long timeCounter;
    private List preloadNames;
    private List preloadLoaderIds;

    ClassFileCache() {
        this.classNameAndLocation = new String[this.capacity];
        this.classFileBytes = new byte[this.capacity][];
        this.lastTimeUsed = new long[this.capacity];
        this.vmSuppliedClassCache = new Hashtable();
        this.preloadNames = new ArrayList();
        this.preloadLoaderIds = new ArrayList();
    }

    static ClassFileCache getDefault() {
        if (defaultClassFileCache == null) {
            defaultClassFileCache = new ClassFileCache();
        }
        return defaultClassFileCache;
    }

    static void resetDefaultCache() {
        defaultClassFileCache = null;
    }

    byte[] getClassFile(String name, String location) throws IOException {
        byte[] res;
        String nameAndLocation = (name + "#" + location).intern();
        if (location.startsWith("<VM_SUPPLIED>")) {
            res = (byte[])this.vmSuppliedClassCache.get(nameAndLocation);
            if (res != null && res.length == 0) {
                try {
                    ProfilerClient client = TargetAppRunner.getDefault().getProfilerClient();
                    if (!this.preloadNames.contains(name)) {
                        this.preloadBytecode(name, location);
                    }
                    String[] names = this.preloadNames.toArray(new String[0]);
                    int[] loadersId = new int[this.preloadLoaderIds.size()];
                    for (int i = 0; i < loadersId.length; ++i) {
                        loadersId[i] = (Integer)this.preloadLoaderIds.get(i);
                    }
                    byte[][] bytes = client.getCachedClassFileBytes(names, loadersId);
                    for (int i = 0; i < bytes.length; ++i) {
                        res = bytes[i];
                        if (res == null) {
                            res = new byte[]{};
                        }
                        if (res.length == 0) continue;
                        this.vmSuppliedClassCache.put(this.getNameAndLocation(names[i], loadersId[i]), res);
                    }
                    this.preloadNames = new ArrayList();
                    this.preloadLoaderIds = new ArrayList();
                    res = (byte[])this.vmSuppliedClassCache.get(nameAndLocation);
                    if (res.length == 0) {
                        throw new IOException("Get class file for " + name + " not found in TA");
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    throw new IOException(ex);
                }
            }
        } else {
            res = this.get(nameAndLocation);
            if (res == null) {
                if (this.size > this.sizeLimit) {
                    this.removeLRUEntry();
                }
                res = this.readAndPut(name, location, nameAndLocation);
            }
        }
        return res;
    }

    void preloadBytecode(String name, String location) {
        byte[] res;
        String nameAndLocation = (name + "#" + location).intern();
        if (location.startsWith("<VM_SUPPLIED>") && (res = (byte[])this.vmSuppliedClassCache.get(nameAndLocation)) != null && res.length == 0) {
            this.preloadNames.add(name);
            String loaderIdStr = location.substring("<VM_SUPPLIED>".length());
            this.preloadLoaderIds.add(Integer.valueOf(loaderIdStr));
        }
    }

    void addVMSuppliedClassFile(String name, int classLoaderId, byte[] buf) {
        String nameAndLocation = this.getNameAndLocation(name, classLoaderId);
        this.vmSuppliedClassCache.put(nameAndLocation, buf);
    }

    private String getNameAndLocation(String name, int classLoaderId) {
        return (name + "#" + ClassRepository.getClassFileLoc(classLoaderId)).intern();
    }

    int hasVMSuppliedClassFile(String name, int classLoaderId) {
        do {
            String nameAndLocation;
            boolean res;
            if (res = this.vmSuppliedClassCache.containsKey(nameAndLocation = this.getNameAndLocation(name, classLoaderId))) {
                return classLoaderId;
            }
            if (classLoaderId != 0) {
                classLoaderId = ClassLoaderTable.getParentLoader(classLoaderId);
            }
            if (classLoaderId != -1) continue;
            MiscUtils.printWarningMessage("Failed to lookup classloader for: " + name);
            return -1;
        } while (classLoaderId != 0);
        return -1;
    }

    private byte[] get(String nameAndLocation) {
        int pos = (nameAndLocation.hashCode() & Integer.MAX_VALUE) % this.capacity;
        while (this.classNameAndLocation[pos] != null && this.classNameAndLocation[pos] != nameAndLocation) {
            pos = (pos + 1) % this.capacity;
        }
        if (this.classNameAndLocation[pos] != null) {
            this.lastTimeUsed[pos] = ++this.timeCounter;
            return this.classFileBytes[pos];
        }
        return null;
    }

    private byte[] readAndPut(String name, String classFileLocation, String nameAndLocation) throws IOException {
        byte[] classFile = this.readClassFile(name, classFileLocation);
        int pos = (nameAndLocation.hashCode() & Integer.MAX_VALUE) % this.capacity;
        while (this.classNameAndLocation[pos] != null) {
            pos = (pos + 1) % this.capacity;
        }
        this.classNameAndLocation[pos] = nameAndLocation;
        this.classFileBytes[pos] = classFile;
        this.lastTimeUsed[pos] = ++this.timeCounter;
        ++this.size;
        return classFile;
    }

    private byte[] readClassFile(String name, String classFileLocation) throws IOException {
        int readBytes;
        String classFileName = name + ".class";
        File location = new File(classFileLocation);
        if (location.isDirectory()) {
            return MiscUtils.readFileIntoBuffer(new FileOrZipEntry(classFileLocation, classFileName));
        }
        ZipFile zip = null;
        if (this.classPath == null) {
            this.classPath = ClassRepository.getClassPath();
        }
        if (this.classPath != null) {
            try {
                zip = this.classPath.getZipFileForName(classFileLocation);
            }
            catch (ZipException e2) {
                throw new IOException("Could not open archive " + classFileLocation);
            }
        } else {
            throw new IOException("Could not get classpath for " + classFileName + " in " + classFileLocation);
        }
        ZipEntry entry = zip.getEntry(classFileName);
        if (entry == null) {
            throw new IOException("Could not find entry for " + classFileName + " in " + classFileLocation);
        }
        int len = (int)entry.getSize();
        byte[] buf = new byte[len];
        InputStream in = zip.getInputStream(entry);
        int ofs = 0;
        int remBytes = len;
        do {
            readBytes = in.read(buf, ofs, remBytes);
            remBytes -= readBytes;
        } while ((ofs += readBytes) < len);
        in.close();
        return buf;
    }

    private void removeLRUEntry() {
        long leastTime = Long.MAX_VALUE;
        int pos = 0;
        for (int i = 0; i < this.capacity; ++i) {
            if (this.lastTimeUsed[i] <= 0L || this.lastTimeUsed[i] >= leastTime) continue;
            pos = i;
        }
        this.classNameAndLocation[pos] = null;
        this.classFileBytes[pos] = null;
        this.lastTimeUsed[pos] = 0L;
        --this.size;
    }
}

