/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerEvent;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.ui.node.DockerContainerNode;
import org.netbeans.modules.docker.ui.node.NodeClosingFactory;
import org.netbeans.modules.docker.ui.node.Refreshable;
import org.netbeans.modules.docker.ui.node.StatefulDockerContainer;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class DockerContainersChildFactory
extends NodeClosingFactory<StatefulDockerContainer>
implements Refreshable,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(DockerContainersChildFactory.class.getName());
    private static final Comparator<DockerContainer> COMPARATOR = new Comparator<DockerContainer>(){

        @Override
        public int compare(DockerContainer o1, DockerContainer o2) {
            return o1.getImage().compareTo(o2.getImage());
        }
    };
    private static final Set<DockerEvent.Status> CHANGE_EVENTS = new HashSet<DockerEvent.Status>();
    private final Map<DockerContainer, WeakReference<StatefulDockerContainer>> cache = new WeakHashMap<DockerContainer, WeakReference<StatefulDockerContainer>>();
    private final RequestProcessor requestProcessor = new RequestProcessor(DockerContainersChildFactory.class);
    private final DockerInstance instance;
    private final RequestProcessor.Task refreshTask;
    private final DockerEvent.Listener listener;

    public DockerContainersChildFactory(DockerInstance instance) {
        this.instance = instance;
        this.refreshTask = this.requestProcessor.create(new Runnable(){

            @Override
            public void run() {
                LOGGER.log(Level.FINE, "Refreshing containers");
                DockerContainersChildFactory.this.refresh();
            }
        });
        this.listener = new DockerEvent.Listener(){

            public void onEvent(DockerEvent event) {
                if (CHANGE_EVENTS.contains(event.getStatus())) {
                    DockerContainersChildFactory.this.refreshTask.schedule(200);
                }
            }
        };
        instance.addContainerListener(this.listener);
    }

    protected Node createNodeForKey(StatefulDockerContainer key) {
        return new DockerContainerNode(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createKeys(List<StatefulDockerContainer> toPopulate) {
        DockerAction facade = new DockerAction(this.instance);
        ArrayList containers = new ArrayList(facade.getContainers());
        Collections.sort(containers, COMPARATOR);
        Map<DockerContainer, WeakReference<StatefulDockerContainer>> map = this.cache;
        synchronized (map) {
            ArrayList<StatefulDockerContainer> fresh = new ArrayList<StatefulDockerContainer>(containers.size());
            for (DockerContainer c : containers) {
                StatefulDockerContainer cached = null;
                WeakReference<StatefulDockerContainer> ref = this.cache.get(c);
                if (ref != null) {
                    cached = (StatefulDockerContainer)ref.get();
                }
                if (cached == null) {
                    cached = new StatefulDockerContainer(c);
                    this.cache.put(c, new WeakReference<StatefulDockerContainer>(cached));
                } else {
                    cached.attach();
                    cached.refresh();
                }
                fresh.add(cached);
            }
            toPopulate.addAll(fresh);
        }
        return true;
    }

    @Override
    public final void refresh() {
        this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.instance.removeContainerListener(this.listener);
        Map<DockerContainer, WeakReference<StatefulDockerContainer>> map = this.cache;
        synchronized (map) {
            for (WeakReference<StatefulDockerContainer> r : this.cache.values()) {
                StatefulDockerContainer c = (StatefulDockerContainer)r.get();
                if (c == null) continue;
                c.close();
            }
            this.cache.clear();
        }
    }

    static {
        Collections.addAll(CHANGE_EVENTS, DockerEvent.Status.COPY, DockerEvent.Status.CREATE, DockerEvent.Status.DESTROY, DockerEvent.Status.RENAME);
    }
}

