/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.jclank.bridge.trace;

import java.io.PrintWriter;
import java.util.Set;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.model.jclank.bridge.impl.CsmJClankSerivicesImpl;
import org.netbeans.modules.cnd.model.jclank.bridge.trace.Bundle;
import org.netbeans.modules.cnd.model.jclank.bridge.trace.JClankDiagnosticAbstractProvider;

public abstract class JClankPreprocessFile
extends JClankDiagnosticAbstractProvider {
    final boolean printTokens;
    final boolean printStatistics;

    public JClankPreprocessFile(boolean printTokens, boolean printStatistics) {
        this.printTokens = printTokens;
        this.printStatistics = printStatistics;
    }

    @Override
    protected void doNativeFileItemDiagnostic(Set<NativeFileItem> nfis, PrintWriter printOut) {
        printOut.printf("====%s\n", this.getDisplayName());
        long totalTime = 0L;
        int numFiles = 0;
        for (NativeFileItem nfi : nfis) {
            try {
                printOut.printf("dumpFileTokens %s...%n", nfi.getAbsolutePath());
                long time = System.currentTimeMillis();
                CsmJClankSerivicesImpl.dumpPreprocessed(nfi, printOut, null, this.printTokens, this.printStatistics);
                ++numFiles;
                time = System.currentTimeMillis() - time;
                totalTime += time;
                printOut.printf("dumpFileTokens %s took %,dms %n", nfi.getAbsolutePath(), time);
            }
            catch (Throwable e) {
                new Exception(nfi.getAbsolutePath(), e).printStackTrace(printOut);
            }
        }
        printOut.printf("====%s for %d files took %,dms\n", this.getDisplayName(), numFiles, totalTime);
    }

    public static final class JClankPrintTokensWOStatistics
    extends JClankPreprocessFile {
        public JClankPrintTokensWOStatistics() {
            super(true, false);
        }

        public String getDisplayName() {
            return Bundle.JClankPrintTokensWOStatistics_displayName();
        }
    }

    public static final class JClankPrintTokensWithStatistics
    extends JClankPreprocessFile {
        public JClankPrintTokensWithStatistics() {
            super(true, true);
        }

        public String getDisplayName() {
            return Bundle.JClankPrintTokensWithStatistics_displayName();
        }
    }

    public static final class JClankOnlyExpandTokensWithStatistics
    extends JClankPreprocessFile {
        public JClankOnlyExpandTokensWithStatistics() {
            super(false, true);
        }

        public String getDisplayName() {
            return Bundle.JClankOnlyExpandTokensWithStatistics_displayName();
        }
    }

    public static final class JClankOnlyExpandTokensWOStatistics
    extends JClankPreprocessFile {
        public JClankOnlyExpandTokensWOStatistics() {
            super(false, false);
        }

        public String getDisplayName() {
            return Bundle.JClankOnlyExpandTokensWOStatistics_displayName();
        }
    }
}

