/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.parsers;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.xml.sax.InputSource;

public final class DocumentInputSource
extends InputSource {
    private static final Logger LOG = Logger.getLogger(DocumentInputSource.class.getName());
    private final Document doc;

    public DocumentInputSource(Document doc) {
        this.doc = doc;
    }

    public Reader getCharacterStream() {
        String text = DocumentInputSource.documentToString(this.doc);
        return new StringReader(text);
    }

    public final void setCharacterStream(Reader reader) {
    }

    public String getSystemId() {
        String system = super.getSystemId();
        if (system == null) {
            FileObject fo = EditorDocumentUtils.getFileObject((Document)this.doc);
            if (fo != null) {
                URL url = fo.toURL();
                system = url.toExternalForm();
            } else {
                LOG.info("XML:DocumentInputSource:No FileObject in stream description.");
            }
        }
        return system;
    }

    private static String documentToString(final Document doc) {
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        };
        doc.render(run);
        return str[0];
    }

    public String toString() {
        return "DocumentInputSource SID:" + this.getSystemId();
    }
}

