/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.JavacardTaskBase;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class OffCardInstallerTask
extends JavacardTaskBase {
    private String classname = "com.sun.javacard.offcardinstaller.Main";
    private CommandlineJava cmdj = this.getCommandLine();
    protected String command;
    protected String port;
    protected String moduleName;
    protected String applicationType;
    protected String jarFile;
    protected String signatureFile;
    protected String appURI;
    protected String aid;
    protected String userName;
    protected String userPassword;
    protected String verbose;
    protected String subCommand;
    protected String platformTarget;
    protected String forced;
    protected String detailed;
    protected Path classpath;
    protected String cjcreExecutable;
    private int cjcreCommandSize = 1;
    protected String httpPort;
    protected String ramSize;
    protected String e2pSize;
    protected String corSize;
    private final String EXTENDED_TYPE = "extended-applet";

    public void setCommand(String command) {
        this.command = command;
    }

    public void setSubCommand(String subCommand) {
        this.subCommand = subCommand;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setAppType(String appType) {
        this.applicationType = appType;
    }

    public void setSigFile(String signatureFile) {
        if (signatureFile.startsWith(".")) {
            String basedir = this.getProject().getBaseDir().getAbsolutePath();
            this.signatureFile = basedir + signatureFile.substring(1);
        } else {
            this.signatureFile = signatureFile;
        }
    }

    public void setInputJarFile(String jarFile) {
        if (jarFile.startsWith(".")) {
            String basedir = this.getProject().getBaseDir().getAbsolutePath();
            this.jarFile = basedir + jarFile.substring(1);
        } else {
            this.jarFile = jarFile;
        }
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public void setAppURI(String appURI) {
        this.appURI = appURI;
    }

    public void setAid(String aid) {
        this.aid = aid;
    }

    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    public void setPlatformTarget(String platformTarget) {
        this.platformTarget = platformTarget;
    }

    public void setForced(String forced) {
        this.forced = forced;
    }

    public void setDetailed(String detailed) {
        this.detailed = detailed;
    }

    public void setCjcreExe(String cjcreExe) {
        this.cjcreExecutable = cjcreExe;
    }

    public void setRamSize(String ramSize) {
        this.ramSize = ramSize;
        this.cjcreCommandSize += 2;
    }

    public void setE2pSize(String e2pSize) {
        this.e2pSize = e2pSize;
        this.cjcreCommandSize += 2;
    }

    public void setCorSize(String corSize) {
        this.corSize = corSize;
        this.cjcreCommandSize += 2;
    }

    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
        ++this.cjcreCommandSize;
    }

    protected void initCard() throws BuildException {
        if (this.cjcreExecutable == null) {
            return;
        }
        Execute cjcreExe = new Execute();
        String[] commandLineArray = new String[this.cjcreCommandSize];
        commandLineArray[0] = this.cjcreExecutable;
        if (this.ramSize != null) {
            commandLineArray[1] = "-ramsize";
            commandLineArray[2] = this.ramSize;
        }
        if (this.e2pSize != null) {
            commandLineArray[3] = "-e2psize";
            commandLineArray[4] = this.e2pSize;
        }
        if (this.corSize != null) {
            commandLineArray[5] = "-corsize";
            commandLineArray[6] = this.corSize;
        }
        if (this.httpPort != null) {
            commandLineArray[7] = "-Dhttp.port=" + this.httpPort;
        }
        cjcreExe.setSpawn(true);
        cjcreExe.setCommandline(commandLineArray);
        cjcreExe.setAntRun(this.getProject());
        try {
            cjcreExe.spawn();
        }
        catch (Exception e) {
            throw new BuildException(messages.getString("offcardinstaller.cjcreError"));
        }
    }

    protected void doIt(String command) throws BuildException {
        this.cmdj.clearJavaArgs();
        this.cmdj.createArgument().setValue(command);
        if (command.equalsIgnoreCase("load")) {
            this.cmdj.createArgument().setValue("-c");
            this.cmdj.createArgument().setValue("http://localhost:" + this.port + "/cardmanager");
            if (this.moduleName == null) {
                throw new BuildException(messages.getString("offcardinstaller.noModuleName"));
            }
            if (this.jarFile == null) {
                throw new BuildException(messages.getString("offcardinstaller.noJarFile"));
            }
            if (this.signatureFile == null) {
                throw new BuildException(messages.getString("offcardinstaller.noSignatureFile"));
            }
            this.cmdj.createArgument().setValue("-n");
            this.cmdj.createArgument().setValue(this.moduleName);
            this.cmdj.createArgument().setValue("-t");
            this.cmdj.createArgument().setValue(this.applicationType);
            this.cmdj.createArgument().setValue(this.jarFile);
            this.cmdj.createArgument().setValue("-s");
            this.cmdj.createArgument().setValue(this.signatureFile);
        }
        if (command.equalsIgnoreCase("create")) {
            this.cmdj.createArgument().setValue("-c");
            this.cmdj.createArgument().setValue("http://localhost:" + this.port + "/cardmanager");
            if (this.moduleName == null) {
                throw new BuildException(messages.getString("offcardinstaller.noModuleName"));
            }
            this.cmdj.createArgument().setValue("-n");
            this.cmdj.createArgument().setValue(this.moduleName);
            if (this.appURI != null) {
                this.cmdj.createArgument().setValue("-i");
                this.cmdj.createArgument().setValue(this.appURI);
            }
            if (this.applicationType.equals("extended-applet") && this.aid != null) {
                this.cmdj.createArgument().setValue("-a");
                this.cmdj.createArgument().setValue(this.aid);
            }
        }
        if (command.equalsIgnoreCase("delete")) {
            this.cmdj.createArgument().setValue("-c");
            this.cmdj.createArgument().setValue("http://localhost:" + this.port + "/cardmanager");
            if (this.appURI == null) {
                throw new BuildException(messages.getString("offcardinstaller.noApplicationURI"));
            }
            this.cmdj.createArgument().setValue("-i");
            this.cmdj.createArgument().setValue(this.appURI);
            if (this.forced != null && this.forced.equalsIgnoreCase("yes")) {
                this.cmdj.createArgument().setValue("-f");
            }
        }
        if (command.equalsIgnoreCase("unload")) {
            this.cmdj.createArgument().setValue("-c");
            this.cmdj.createArgument().setValue("http://localhost:" + this.port + "/cardmanager");
            if (this.moduleName == null) {
                throw new BuildException(messages.getString("offcardinstaller.noModuleName"));
            }
            this.cmdj.createArgument().setValue("-n");
            this.cmdj.createArgument().setValue(this.moduleName);
            if (this.forced != null && this.forced.equalsIgnoreCase("yes")) {
                this.cmdj.createArgument().setValue("-f");
            }
        }
        if (command.equalsIgnoreCase("list")) {
            this.cmdj.createArgument().setValue("-c");
            this.cmdj.createArgument().setValue("http://localhost:" + this.port + "/cardmanager");
            if (this.detailed != null && this.detailed.equalsIgnoreCase("yes")) {
                this.cmdj.createArgument().setValue("-d");
            }
        }
        if (this.userName != null) {
            if (this.userPassword == null) {
                throw new BuildException(messages.getString("offcardinstaller.noUserPassrd"));
            }
            this.cmdj.createArgument().setValue("-u");
            this.cmdj.createArgument().setValue(this.userName);
            this.cmdj.createArgument().setValue("-p");
            this.cmdj.createArgument().setValue(this.userPassword);
        }
        if (command.equalsIgnoreCase("help") && this.subCommand != null) {
            this.cmdj.createArgument().setValue(this.subCommand);
        }
        if (this.verbose != null && this.verbose.equalsIgnoreCase("yes")) {
            this.cmdj.createArgument().setValue("-v");
        }
        if (this.platformTarget != null) {
            this.cmdj.createArgument().setValue("-T");
            this.cmdj.createArgument().setValue(this.platformTarget);
        }
        String[] args = this.cmdj.getJavaCommand().getArguments();
        Object[] arguments = new Object[]{args};
        AntClassLoader loader = this.getProject().createClassLoader(this.classpath);
        loader.setParent(this.getProject().getCoreLoader());
        loader.setParentFirst(true);
        loader.addJavaLibraries();
        loader.setIsolated(true);
        loader.setThreadContextLoader();
        Class<?> target = null;
        try {
            loader.forceLoadClass(this.classname);
            target = Class.forName(this.classname, true, (ClassLoader)loader);
        }
        catch (Exception e) {
            throw new BuildException(messages.getString("offcardinstaller.loadPackagerError"));
        }
        Method execute = null;
        try {
            execute = target.getMethod("execute", String[].class);
        }
        catch (Exception e) {
            throw new BuildException(messages.getString("offcardinstaller.noExecuteMethod"));
        }
        try {
            execute.invoke(null, arguments);
        }
        catch (Exception e) {
            throw new BuildException(messages.getString("offcardinstaller.packagerError"));
        }
    }

    public void execute() throws BuildException {
        this.initCard();
        if (this.command == null) {
            throw new BuildException(messages.getString("offcardinstaller.noCommand"));
        }
        this.classpath = this.cmdj.getClasspath();
        if (this.classpath == null) {
            throw new BuildException(messages.getString("offcardinstaller.noClassPath"));
        }
        if (this.command.equalsIgnoreCase("loadcreate")) {
            this.doIt("load");
            this.doIt("create");
        } else {
            this.doIt(this.command);
        }
    }
}

