/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlValidation {
    public static String xmldocString;
    public static String schemadocString;
    public static String usageString;
    public static String successString;
    public static String failureString;
    public static String errorInfo;

    public static void main(String[] args) {
        if (args.length == 2) {
            xmldocString = args[0];
            schemadocString = args[1];
            if (XmlValidation.isValid(xmldocString, schemadocString)) {
                System.err.format(successString, xmldocString, schemadocString);
            } else {
                System.err.format(failureString, xmldocString, schemadocString, errorInfo);
            }
        } else {
            XmlValidation.usage(true);
            System.exit(1);
        }
    }

    private static void usage(boolean isError) {
        if (isError) {
            System.err.println(usageString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(String xmldoc, String xsddoc) {
        Validator validator;
        Document document;
        block12: {
            document = null;
            validator = null;
            errorInfo = null;
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setNamespaceAware(true);
                DocumentBuilder parser = builderFactory.newDocumentBuilder();
                document = parser.parse(new File(xmldoc));
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource schemaFile = new StreamSource(new File(xsddoc));
                Schema schema = factory.newSchema(schemaFile);
                validator = schema.newValidator();
            }
            catch (ParserConfigurationException e) {
                errorInfo = "Step 1:" + e.toString();
                return (boolean)errorInfo;
            }
            catch (SAXException e) {
                errorInfo = "Step 2:" + e.toString();
                return (boolean)errorInfo;
            }
            catch (IOException e) {
                errorInfo = "Step 3:" + e.toString();
                return (boolean)errorInfo;
            }
            finally {
                if (errorInfo == null) break block12;
                return false;
            }
        }
        try {
            validator.validate(new DOMSource(document));
        }
        catch (SAXException e) {
            errorInfo = "Step 4:" + e.toString();
        }
        catch (IOException e) {
            errorInfo = "Step 5:" + e.toString();
        }
        return errorInfo == null;
    }

    public static String getErrorInfo() {
        if (errorInfo != null) {
            return "";
        }
        return errorInfo;
    }

    static {
        usageString = "usage: XmlValidation <xmlDocument> <schemaDocument>";
        successString = "validated \"%s\" against \"%s\" successfully!\n";
        failureString = "failed validation: \"%s\" against \"%s\". Error #%s!\n";
        errorInfo = null;
    }
}

