/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;

public class FingerprintScanner {
    public static final String OUTPUT_FORMAT_VERSION = "__output_format_version";
    public static final String TOOL_VERSION_STRING = "__tool_version_string";
    public static final String TOOL_VERSION_NUMBER = "__tool_version_number";
    public static final String TOOL_BUILD_NUMBER = "__tool_build_number";
    public static final String SYSTEM_MACRO = "__system_macro";
    public static final String SYSTEM_INCLUDE = "__system_include";
    public static final String SYSTEM_INCLUDE_HEADER = "__dash_include";

    public static Result scaneLine(String line) {
        if (!line.startsWith("#")) {
            return null;
        }
        if ((line = line.substring(1).trim()).startsWith(SYSTEM_INCLUDE)) {
            line = line.substring(SYSTEM_INCLUDE.length()).trim();
            return new ResultImpl(Kind.SystemPath, FingerprintScanner.removeQuotes(line));
        }
        if (line.startsWith(SYSTEM_MACRO)) {
            String[] macro = CCCCompiler.getMacro(line = line.substring(SYSTEM_MACRO.length()).trim());
            if (CCCCompiler.isValidMacroName(macro[0])) {
                line = macro[1] != null ? macro[0] + "=" + macro[1] : macro[0];
                return new ResultImpl(Kind.SystemMacro, line);
            }
        } else if (line.startsWith(SYSTEM_INCLUDE_HEADER)) {
            line = line.substring(SYSTEM_INCLUDE_HEADER.length()).trim();
            return new ResultImpl(Kind.SystemIncludeHeader, FingerprintScanner.removeQuotes(line));
        }
        return null;
    }

    private static String removeQuotes(String line) {
        if (line.startsWith("\"") && line.endsWith("\"") && line.length() > 1) {
            return line.substring(1, line.length() - 1);
        }
        return line;
    }

    private static final class ResultImpl
    implements Result {
        private final Kind kind;
        private final String result;

        private ResultImpl(Kind kind, String result) {
            this.kind = kind;
            this.result = result;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public String getResult() {
            return this.result;
        }
    }

    public static interface Result {
        public Kind getKind();

        public String getResult();
    }

    public static enum Kind {
        SystemMacro,
        UserMacro,
        SystemPath,
        UserPath,
        SystemIncludeHeader;

    }
}

