/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.support;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.toolchain.compilerset.APIAccessor;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerAccessorImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainValidator;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.WeakSet;

public final class ToolchainUtilities {
    private static final Set<ChangeListener> codeAssistanceChanged = new WeakSet();

    private ToolchainUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCodeAssistanceChangeListener(ChangeListener l) {
        Set<ChangeListener> set = codeAssistanceChanged;
        synchronized (set) {
            codeAssistanceChanged.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCodeAssistanceChangeListener(ChangeListener l) {
        Set<ChangeListener> set = codeAssistanceChanged;
        synchronized (set) {
            codeAssistanceChanged.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireCodeAssistanceChange(CompilerSetManager csm) {
        ChangeEvent ev = new ChangeEvent(csm);
        Set<ChangeListener> set = codeAssistanceChanged;
        synchronized (set) {
            for (ChangeListener l : codeAssistanceChanged) {
                l.stateChanged(ev);
            }
        }
    }

    public static List<CompilerSet> findRemoteCompilerSets(CompilerSetManager csm, String path) {
        if (!csm.getClass().equals(CompilerSetManagerImpl.class)) {
            throw new UnsupportedOperationException("CompilerSetManager class can not be overriden by clients");
        }
        return ((CompilerSetManagerImpl)csm).findRemoteCompilerSets(path);
    }

    public static CompilerSet createCopy(CompilerSet cs, ExecutionEnvironment env, CompilerFlavor flavor, String directory, String name, String displayName, boolean autoGenerated, boolean keepToolFlavor, String setBuildPath, String setRunPath) {
        if (!cs.getClass().equals(CompilerSetImpl.class)) {
            throw new UnsupportedOperationException("CompilerSet class can not be overriden by clients");
        }
        return ((CompilerSetImpl)cs).createCopy(env, flavor, directory, name, displayName, autoGenerated, keepToolFlavor, setBuildPath, setRunPath);
    }

    public static CompilerSet initCompilerSet(CompilerSetManager csm, ExecutionEnvironment env, CompilerFlavor flavor, String directory) {
        if (!csm.getClass().equals(CompilerSetManagerImpl.class)) {
            throw new UnsupportedOperationException("CompilerSetManager class can not be overriden by clients");
        }
        CompilerSetImpl cs = CompilerSetImpl.create(flavor, env, directory);
        cs.setAutoGenerated(false);
        ((CompilerSetManagerImpl)csm).initCompilerSet(cs);
        return cs;
    }

    public static void setCSName(CompilerSet cs, String compilerSetName) {
        if (!cs.getClass().equals(CompilerSetImpl.class)) {
            throw new UnsupportedOperationException("CompilerSet class can not be overriden by clients");
        }
        ((CompilerSetImpl)cs).setName(compilerSetName);
    }

    public static CompilerSetManager create(ExecutionEnvironment execEnv) {
        return CompilerSetManagerAccessorImpl.create(execEnv);
    }

    public static CompilerSetManager getDeepCopy(ExecutionEnvironment execEnv, boolean initialize) {
        return CompilerSetManagerAccessorImpl.getDeepCopy(execEnv, initialize);
    }

    public static CompilerSetManager deepCopy(CompilerSetManager csm) {
        if (!csm.getClass().equals(CompilerSetManagerImpl.class)) {
            throw new UnsupportedOperationException("CompilerSetManager class can not be overriden by clients");
        }
        return ((CompilerSetManagerImpl)csm).deepCopy();
    }

    public static void saveCompileSetManagers(Collection<CompilerSetManager> allCSMs, List<ExecutionEnvironment> liveServers) {
        CompilerSetManagerAccessorImpl.setManagers(allCSMs, liveServers);
    }

    public static String getUniqueCompilerSetName(CompilerSetManager csm, String baseName) {
        if (!csm.getClass().equals(CompilerSetManagerImpl.class)) {
            throw new UnsupportedOperationException("CompilerSetManager class can not be overriden by clients");
        }
        return ((CompilerSetManagerImpl)csm).getUniqueCompilerSetName(baseName);
    }

    public static void setModifyBuildPath(CompilerSet cs, String modifyBuildPath) {
        if (!cs.getClass().equals(CompilerSetImpl.class)) {
            throw new UnsupportedOperationException("CompilerSet class can not be overriden by clients");
        }
        ((CompilerSetImpl)cs).setModifyBuildPath(modifyBuildPath);
    }

    public static void setModifyRunPath(CompilerSet cs, String modifyRunPath) {
        if (!cs.getClass().equals(CompilerSetImpl.class)) {
            throw new UnsupportedOperationException("CompilerSet class can not be overriden by clients");
        }
        ((CompilerSetImpl)cs).setModifyRunPath(modifyRunPath);
    }

    public static void setToolPath(Tool tool, String p) {
        APIAccessor.get().setToolPath(tool, p);
    }

    public static void setCharset(Charset charset, CompilerSet cs) {
        APIAccessor.get().setCharset(charset, cs);
    }

    public static void fixCSM(Map<Tool, List<List<String>>> needReset, CompilerSetManager csm) {
        ToolchainValidator.INSTANCE.applyChanges(needReset, csm);
    }

    public static boolean isUnsupportedMake(String name) {
        name = CndPathUtilities.getBaseName((String)name);
        return name.toLowerCase().equals("mingw32-make.exe");
    }

    public static Pair<String, String> modifyPathEnvVariable(ExecutionEnvironment execEnv, Map<String, String> env, CompilerSet cs, String type) {
        String macro = "run".equals(type) ? cs.getModifyRunPath() : cs.getModifyBuildPath();
        MacroConverter converter = new MacroConverter(execEnv, env);
        if (converter.isWindows) {
            String commands = CompilerSetUtils.getCommandFolder(cs);
            String baseMinGW = CompilerSetUtils.getMinGWBaseFolder(cs);
            String path = "";
            if (commands != null && !commands.isEmpty()) {
                path = commands;
            }
            if (baseMinGW != null && !baseMinGW.isEmpty()) {
                path = path.isEmpty() ? baseMinGW : path + ";" + baseMinGW;
            }
            converter.updateUtilitiesPath(path);
        }
        converter.updateToolPath(cs.getDirectory());
        String expandedPath = converter.expand(macro);
        env.put(converter.pathName, expandedPath);
        return Pair.of((Object)converter.pathName, (Object)expandedPath);
    }

    private static final class MacroConverter {
        private final MacroExpanderFactory.MacroExpander expander;
        private final Map<String, String> envVariables;
        private String homeDir;
        private String pathName = "PATH";
        private String pathSeparator = ";";
        private boolean isWindows = false;

        public MacroConverter(ExecutionEnvironment env, Map<String, String> envVariables) {
            this.envVariables = new HashMap<String, String>(envVariables);
            if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                    this.envVariables.putAll(hostInfo.getEnvironment());
                    this.homeDir = hostInfo.getUserDir();
                    this.pathName = this.getPathName(env, hostInfo);
                    this.pathSeparator = this.getPathSeparator(hostInfo);
                }
                catch (IOException | ConnectionManager.CancellationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.expander = MacroExpanderFactory.getExpander((ExecutionEnvironment)env, (boolean)false);
        }

        private String getPathName(ExecutionEnvironment env, HostInfo hostInfo) {
            if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                this.isWindows = true;
                for (String key : HostInfoProvider.getEnv((ExecutionEnvironment)env).keySet()) {
                    if (!key.toLowerCase(Locale.getDefault()).equals("path")) continue;
                    return key.substring(0, 4);
                }
            }
            return "PATH";
        }

        private String getPathSeparator(HostInfo hostInfo) {
            if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                return ";";
            }
            return ":";
        }

        private void updateUtilitiesPath(String utilitiesPath) {
            this.envVariables.put("UTILITIES_PATH", utilitiesPath);
        }

        private void updateToolPath(String toolPath) {
            this.envVariables.put("TOOLS_PATH", toolPath);
        }

        public String expand(String in) {
            try {
                if (this.homeDir != null) {
                    if (in.startsWith("~")) {
                        in = this.homeDir + in.substring(1);
                    }
                    in = in.replace(":~", ":" + this.homeDir);
                    in = in.replace(";~", ";" + this.homeDir);
                }
                if (this.pathName != null && !"PATH".equals(this.pathName)) {
                    in = in.replace("${PATH}", "${" + this.pathName + "}");
                }
                if (this.pathSeparator != null && !";".equals(this.pathSeparator)) {
                    in = in.replace(";", this.pathSeparator);
                }
                return this.expander != null ? this.expander.expandMacros(in, this.envVariables) : in;
            }
            catch (ParseException parseException) {
                return in;
            }
        }
    }
}

