/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class SurroundWithIfndef
implements Fix {
    private final BaseDocument doc;
    private final CsmFile file;
    private final String macroIdentifier;
    private final CsmReference ref;

    public SurroundWithIfndef(Document doc, CsmFile file, CsmReference ref, String macroIdentifier) {
        this.doc = (BaseDocument)doc;
        this.file = file;
        this.ref = ref;
        this.macroIdentifier = macroIdentifier;
    }

    public String getText() {
        return NbBundle.getMessage(SurroundWithIfndef.class, (String)"HINT_Ifndef");
    }

    public ChangeInfo implement() throws Exception {
        CsmFileInfoQuery query = CsmFileInfoQuery.getDefault();
        int line = query.getLineColumnByOffset(this.file, this.ref.getStartOffset())[0];
        int startOffset = (int)query.getOffset(this.file, line, 1);
        int endOffset = (int)query.getOffset(this.file, line + 1, 1) - 1;
        Position startPosition = NbDocument.createPosition((Document)this.doc, (int)startOffset, (Position.Bias)Position.Bias.Forward);
        Position endPosition = NbDocument.createPosition((Document)this.doc, (int)endOffset, (Position.Bias)Position.Bias.Forward);
        String ifndefText = "#ifndef " + this.macroIdentifier + "\n";
        this.doc.insertString(startPosition.getOffset(), ifndefText, null);
        this.doc.insertString(endPosition.getOffset(), "\n#endif", null);
        return null;
    }
}

