/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VImage;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Vector;
import net.claribole.zgrviewer.BaseEventHandler;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.LElem;
import net.claribole.zgrviewer.ZGRApplet;
import net.claribole.zvtm.engine.ViewEventHandler;

public class ZgrAppletEvtHdlr
extends BaseEventHandler
implements ViewEventHandler {
    ZGRApplet application;
    GraphicsManager grMngr;

    ZgrAppletEvtHdlr(ZGRApplet app, GraphicsManager gm) {
        this.application = app;
        this.grMngr = gm;
    }

    public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        this.lastJPX = jpx;
        this.lastJPY = jpy;
        if (this.inZoomWindow) {
            if (this.grMngr.dmPortal.coordInsideBar(jpx, jpy)) {
                this.draggingZoomWindow = true;
            } else {
                this.draggingZoomWindowContent = true;
            }
        } else if (this.inMagWindow) {
            this.grMngr.vsm.stickToMouse(this.grMngr.magWindow);
            this.draggingMagWindow = true;
        } else {
            this.grMngr.rememberLocation(v.cams[0].getLocation());
            if (mod == 0 || mod == 1 || mod == 4 || mod == 5) {
                this.manualLeftButtonMove = true;
                this.lastJPX = jpx;
                this.lastJPY = jpy;
                v.setDrawDrag(true);
                this.grMngr.vsm.activeView.mouse.setSensitivity(false);
                this.activeCam = this.grMngr.vsm.getActiveCamera();
            } else if (mod == 6) {
                this.zoomingInRegion = true;
                this.x1 = v.getVCursor().vx;
                this.y1 = v.getVCursor().vy;
                v.setDrawRect(true);
            }
        }
    }

    public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        this.draggingZoomWindow = false;
        this.draggingZoomWindowContent = false;
        if (this.draggingMagWindow) {
            this.draggingMagWindow = false;
            this.grMngr.vsm.unstickFromMouse();
        }
        if (this.zoomingInRegion) {
            v.setDrawRect(false);
            this.x2 = v.getVCursor().vx;
            this.y2 = v.getVCursor().vy;
            if (Math.abs(this.x2 - this.x1) >= 4L && Math.abs(this.y2 - this.y1) >= 4L) {
                this.grMngr.vsm.centerOnRegion(this.grMngr.vsm.getActiveCamera(), ConfigManager.ANIM_MOVE_LENGTH, this.x1, this.y1, this.x2, this.y2);
            }
            this.zoomingInRegion = false;
        } else if (this.manualLeftButtonMove) {
            this.grMngr.vsm.animator.Xspeed = 0.0;
            this.grMngr.vsm.animator.Yspeed = 0.0;
            this.grMngr.vsm.animator.Aspeed = 0.0f;
            v.setDrawDrag(false);
            this.grMngr.vsm.activeView.mouse.setSensitivity(true);
            if (this.autoZooming) {
                this.unzoom(v);
            }
            this.manualLeftButtonMove = false;
        }
    }

    public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            if (v.lastGlyphEntered() != null) {
                this.grMngr.tp.selectButton((VImage)v.lastGlyphEntered());
            }
        } else if (this.grMngr.tp.isFadingLensNavMode() || this.grMngr.tp.isProbingLensNavMode() || this.grMngr.tp.isMeltingLensNavMode()) {
            this.lastJPX = jpx;
            this.lastJPY = jpy;
            this.lastVX = v.getVCursor().vx;
            this.lastVY = v.getVCursor().vy;
            if (this.grMngr.lensType != 0) {
                this.grMngr.zoomInPhase2(this.lastVX, this.lastVY);
            } else {
                if (this.cursorNearBorder) {
                    return;
                }
                this.grMngr.zoomInPhase1(jpx, jpy);
            }
        } else if (this.grMngr.tp.isDragMagNavMode()) {
            this.grMngr.triggerDM(jpx, jpy);
        } else if (clickNumber == 2) {
            this.click2(v, mod, jpx, jpy, clickNumber, e);
        } else {
            Glyph g = v.lastGlyphEntered();
            if (mod == 1) {
                this.grMngr.highlightElement(g, v.cams[0], v.getVCursor(), true);
            } else if (g != null && g != this.grMngr.boundingBox) {
                this.grMngr.vsm.centerOnGlyph(g, v.cams[0], ConfigManager.ANIM_MOVE_LENGTH, true, ConfigManager.MAG_FACTOR);
            }
        }
    }

    public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.grMngr.paMngr.requestToolPaletteRelocation();
    }

    public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        Glyph g = v.lastGlyphEntered();
        if (g != null && g != this.grMngr.boundingBox) {
            if (g.getOwner() != null) {
                this.getAndDisplayURL((LElem)g.getOwner(), g);
            }
        } else {
            this.attemptDisplayEdgeURL(v.getVCursor(), v.cams[0]);
        }
    }

    public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        if (this.grMngr.tp.isFadingLensNavMode() || this.grMngr.tp.isProbingLensNavMode() || this.grMngr.tp.isMeltingLensNavMode()) {
            this.lastJPX = jpx;
            this.lastJPY = jpy;
        }
    }

    public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        if (this.grMngr.tp.isFadingLensNavMode() || this.grMngr.tp.isProbingLensNavMode() || this.grMngr.tp.isMeltingLensNavMode()) {
            this.lastJPX = jpx;
            this.lastJPY = jpy;
            this.lastVX = v.getVCursor().vx;
            this.lastVY = v.getVCursor().vy;
            if (this.grMngr.lensType != 0) {
                this.grMngr.zoomOutPhase2();
            } else {
                if (this.cursorNearBorder) {
                    return;
                }
                this.grMngr.zoomOutPhase1(jpx, jpy, this.lastVX, this.lastVY);
            }
        }
    }

    public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
        this.lx = jpx;
        this.ly = jpy;
        if (jpx - GraphicsManager.LENS_R1 < 0) {
            this.lx = GraphicsManager.LENS_R1;
            this.cursorNearBorder = true;
        } else if (jpx + GraphicsManager.LENS_R1 > this.grMngr.panelWidth) {
            this.lx = this.grMngr.panelWidth - GraphicsManager.LENS_R1;
            this.cursorNearBorder = true;
        } else {
            this.cursorNearBorder = false;
        }
        if (jpy - GraphicsManager.LENS_R1 < 0) {
            this.ly = GraphicsManager.LENS_R1;
            this.cursorNearBorder = true;
        } else if (jpy + GraphicsManager.LENS_R1 > this.grMngr.panelHeight) {
            this.ly = this.grMngr.panelHeight - GraphicsManager.LENS_R1;
            this.cursorNearBorder = true;
        }
        if (this.grMngr.lensType != 0 && this.grMngr.lens != null) {
            this.grMngr.moveLens(this.lx, this.ly, e.getWhen());
        } else if (this.grMngr.tp.isEnabled()) {
            if (this.grMngr.tp.insidePaletteTriggerZone(jpx, jpy)) {
                if (!this.grMngr.tp.isShowing()) {
                    this.grMngr.tp.show();
                }
            } else if (this.grMngr.tp.isShowing()) {
                this.grMngr.tp.hide();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        if (mod != 6 && buttonNumber == 1) {
            if (this.draggingZoomWindow) {
                this.grMngr.dmPortal.move(jpx - this.lastJPX, jpy - this.lastJPY);
                this.lastJPX = jpx;
                this.lastJPY = jpy;
                this.grMngr.vsm.repaintNow();
            } else if (this.draggingZoomWindowContent) {
                this.tfactor = (this.grMngr.dmCamera.focal + this.grMngr.dmCamera.altitude) / this.grMngr.dmCamera.focal;
                Camera camera = this.grMngr.dmCamera;
                synchronized (camera) {
                    this.grMngr.dmCamera.move(Math.round(this.tfactor * (float)(this.lastJPX - jpx)), Math.round(this.tfactor * (float)(jpy - this.lastJPY)));
                    this.lastJPX = jpx;
                    this.lastJPY = jpy;
                    this.grMngr.updateMagWindow();
                }
            } else if (this.draggingMagWindow) {
                this.grMngr.updateZoomWindow();
            } else {
                this.tfactor = (this.activeCam.focal + Math.abs(this.activeCam.altitude)) / this.activeCam.focal;
                if (mod == 1 || mod == 5) {
                    this.grMngr.vsm.animator.Xspeed = 0.0;
                    this.grMngr.vsm.animator.Yspeed = 0.0;
                    this.grMngr.vsm.animator.Aspeed = this.activeCam.altitude > 0.0f ? (float)((long)((float)(this.lastJPY - jpy) * (this.tfactor / this.cfactor))) : (float)((long)((float)(this.lastJPY - jpy) / (this.tfactor * this.cfactor)));
                } else {
                    this.jpxD = jpx - this.lastJPX;
                    this.jpyD = this.lastJPY - jpy;
                    this.grMngr.vsm.animator.Xspeed = this.activeCam.altitude > 0.0f ? (double)((long)((float)this.jpxD * (this.tfactor / this.cfactor))) : (double)((long)((float)this.jpxD / (this.tfactor * this.cfactor)));
                    this.grMngr.vsm.animator.Yspeed = this.activeCam.altitude > 0.0f ? (double)((long)((float)this.jpyD * (this.tfactor / this.cfactor))) : (double)((long)((float)this.jpyD / (this.tfactor * this.cfactor)));
                    this.grMngr.vsm.animator.Aspeed = 0.0f;
                    if (ZGRApplet.cfgMngr.isSDZoomEnabled()) {
                        this.dragValue = Math.sqrt(Math.pow(this.jpxD, 2.0) + Math.pow(this.jpyD, 2.0));
                        if (!this.autoZooming) {
                            if (this.dragValue > ZGRApplet.cfgMngr.SD_ZOOM_THRESHOLD) {
                                this.autoZooming = true;
                                this.grMngr.vsm.animator.createCameraAnimation(300L, (short)3, new Float(ZGRApplet.cfgMngr.autoZoomFactor * (double)(v.cams[0].getAltitude() + v.cams[0].getFocal())), v.cams[0].getID());
                            }
                        }
                    }
                }
            }
        }
        if (this.grMngr.lensType != 0 && this.grMngr.lens != null) {
            this.grMngr.moveLens(jpx, jpy, e.getWhen());
        }
    }

    public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
        if (this.grMngr.lensType != 0 && this.grMngr.lens != null) {
            if (wheelDirection == 1) {
                this.grMngr.magnifyFocus(1.0, this.grMngr.lensType, this.grMngr.mainCamera);
            } else {
                this.grMngr.magnifyFocus(-1.0, this.grMngr.lensType, this.grMngr.mainCamera);
            }
        } else if (this.inZoomWindow) {
            this.tfactor = (this.grMngr.dmCamera.focal + Math.abs(this.grMngr.dmCamera.altitude)) / this.grMngr.dmCamera.focal;
            if (wheelDirection == 1) {
                this.grMngr.dmCamera.altitudeOffset(-this.tfactor * 21.0f);
            } else {
                this.grMngr.dmCamera.altitudeOffset(this.tfactor * 22.0f);
            }
            this.grMngr.updateMagWindow();
            this.grMngr.vsm.repaintNow();
        } else {
            this.tfactor = (this.grMngr.mainCamera.focal + Math.abs(this.grMngr.mainCamera.altitude)) / this.grMngr.mainCamera.focal;
            if (wheelDirection == 1) {
                this.grMngr.mainCamera.altitudeOffset(this.tfactor * 21.0f);
                this.grMngr.cameraMoved();
            } else {
                this.grMngr.mainCamera.altitudeOffset(-this.tfactor * 22.0f);
                this.grMngr.cameraMoved();
            }
        }
    }

    public void enterGlyph(Glyph g) {
        this.grMngr.mainView.setStatusBarText(" ");
        if (g == this.grMngr.magWindow) {
            this.inMagWindow = true;
            return;
        }
        if (g == this.grMngr.boundingBox) {
            return;
        }
        if (this.grMngr.tp.isHighlightMode()) {
            this.grMngr.highlightElement(g, null, null, true);
        } else {
            g.highlight(true, null);
        }
    }

    public void exitGlyph(Glyph g) {
        if (g == this.grMngr.magWindow) {
            this.inMagWindow = false;
            return;
        }
        if (g == this.grMngr.boundingBox) {
            return;
        }
        if (this.application.grMngr.tp.isHighlightMode()) {
            this.grMngr.unhighlightAll();
        } else {
            g.highlight(false, null);
        }
    }

    public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void viewActivated(View v) {
    }

    public void viewDeactivated(View v) {
    }

    public void viewIconified(View v) {
    }

    public void viewDeiconified(View v) {
    }

    public void viewClosing(View v) {
    }

    void attemptDisplayEdgeURL(VCursor mouse, Camera cam) {
        Vector otherGlyphs = mouse.getIntersectingTexts(cam);
        if (otherGlyphs != null && otherGlyphs.size() > 0) {
            Glyph g = (Glyph)otherGlyphs.firstElement();
            if (g.getOwner() != null) {
                this.getAndDisplayURL((LElem)g.getOwner(), g);
            }
        } else {
            Glyph g;
            otherGlyphs = mouse.getIntersectingPaths(cam);
            if (otherGlyphs != null && otherGlyphs.size() > 0 && (g = (Glyph)otherGlyphs.firstElement()).getOwner() != null) {
                this.getAndDisplayURL((LElem)g.getOwner(), g);
            }
        }
    }

    void getAndDisplayURL(LElem noa, Glyph g) {
        String url = noa.getURL(g);
        if (url != null && url.length() > 0) {
            this.application.displayURLinBrowser(url);
        }
    }

    protected void unzoom(ViewPanel v) {
        this.grMngr.vsm.animator.createCameraAnimation(300L, (short)3, new Float(ZGRApplet.cfgMngr.autoUnzoomFactor * (double)(v.cams[0].getAltitude() + v.cams[0].getFocal())), v.cams[0].getID());
        this.autoZooming = false;
    }
}

