/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management.client;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.management.client.AgentConnection;
import org.opensolaris.opengrok.management.client.ConfigurationsFrame;
import org.opensolaris.opengrok.management.client.NotificationsFrame;
import org.opensolaris.opengrok.management.client.SettingsFrame;
import org.opensolaris.opengrok.management.client.SettingsPersistence;

public class OpenGrokTrayApp {
    private static TrayIcon trayIcon;
    private static String cfgfile;
    private final SettingsPersistence settings;
    private static final Logger log;
    public static final String OPENGROKICONURL = "opengrok.gif";
    public static final String INDEXWARNINGICONURL = "opengrok_indexwarning.gif";
    public static final String NOCONNECTIONICONURL = "opengrok_noconnection.gif";
    private AgentConnection agent = null;
    private boolean agentConnected = false;
    private Image opengrokImage;
    private Image indexWarningImage;
    private Image noConnectionImage;
    private Image currentIcon;

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-config")) continue;
                if (++i < args.length) {
                    cfgfile = args[i];
                    continue;
                }
                System.err.println("-config, argument missing: config file");
                System.exit(1);
            }
            OpenGrokTrayApp ogta = new OpenGrokTrayApp(cfgfile);
            ogta.enableSystemTray();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "Exception starting ", ex);
        }
    }

    public OpenGrokTrayApp(String cfgfile) throws IOException {
        this.settings = new SettingsPersistence(cfgfile);
        this.loadImages();
        OpenGrokLogger.setupLogger(this.settings.getProperty("org.opensolaris.opengrok.management.logging.path"), this.settings.getFileLogLevel(), this.settings.getConsoleLogLevel());
        this.currentIcon = this.tryAgentConnect() ? this.opengrokImage : this.noConnectionImage;
    }

    private ActionListener getAgentActionListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.info("Got Event " + e.getActionCommand());
                trayIcon.displayMessage("OpenGrok Indexer", "Files have been deleted/added", TrayIcon.MessageType.INFO);
                trayIcon.setImage(OpenGrokTrayApp.this.indexWarningImage);
            }
        };
        return actionListener;
    }

    private ActionListener getExitListener() {
        ActionListener exitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.info("Exiting...");
                if (OpenGrokTrayApp.this.agent != null && OpenGrokTrayApp.this.agent.isConnected()) {
                    OpenGrokTrayApp.this.agent.unregister();
                }
                System.exit(0);
            }
        };
        return exitListener;
    }

    private ActionListener getConfigurationListener() {
        ActionListener configListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.finer("Config...");
                try {
                    ConfigurationsFrame sf = new ConfigurationsFrame(OpenGrokTrayApp.this.agent);
                    sf.setVisible(true);
                }
                catch (IOException ex) {
                    Logger.getLogger(OpenGrokTrayApp.class.getName()).log(Level.SEVERE, null, ex);
                }
                log.finer("Done config");
            }
        };
        return configListener;
    }

    private MouseListener getMouseListener() {
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                log.finest("Tray Icon - Mouse clicked!");
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                log.finest("Tray Icon - Mouse entered!");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                log.finest("Tray Icon - Mouse exited!");
            }

            @Override
            public void mousePressed(MouseEvent e) {
                log.finest("Tray Icon - Mouse pressed!");
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                log.finest("Tray Icon - Mouse released!");
            }
        };
        return mouseListener;
    }

    private WindowListener getNotificationWindowListener() {
        WindowListener notificationWindowListener = new WindowListener(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                log.finest("Received window opened");
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                log.finest("Received window closing");
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                log.info("Received window closing");
                if (OpenGrokTrayApp.this.agent != null && OpenGrokTrayApp.this.agent.isConnected()) {
                    OpenGrokTrayApp.this.currentIcon = OpenGrokTrayApp.this.opengrokImage;
                } else {
                    OpenGrokTrayApp.this.currentIcon = OpenGrokTrayApp.this.noConnectionImage;
                }
                trayIcon.setImage(OpenGrokTrayApp.this.currentIcon);
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
                log.finest("Received window iconified");
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
                log.finest("Received window deiconified");
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
                log.finest("Received window activated");
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
                log.finest("Received window deactivated");
            }
        };
        return notificationWindowListener;
    }

    private ActionListener getSettingsListener(final WindowListener settingsWindowListener) {
        ActionListener settingsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.finer("Settings...");
                SettingsFrame sf = new SettingsFrame(OpenGrokTrayApp.this.settings);
                sf.addWindowListener(settingsWindowListener);
                sf.setVisible(true);
                log.finer("Done settings");
            }
        };
        return settingsListener;
    }

    private WindowListener getSettingsWindowListener() {
        WindowListener settingsWindowListener = new WindowListener(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                log.finest("Received window opened");
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                log.finest("Received window closing " + arg0);
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                log.info("Received window closing");
                if (!OpenGrokTrayApp.this.agentConnected) {
                    OpenGrokTrayApp.this.tryAgentConnect();
                }
                if (OpenGrokTrayApp.this.agentConnected) {
                    OpenGrokTrayApp.this.currentIcon = OpenGrokTrayApp.this.opengrokImage;
                } else {
                    OpenGrokTrayApp.this.currentIcon = OpenGrokTrayApp.this.noConnectionImage;
                }
                trayIcon.setImage(OpenGrokTrayApp.this.currentIcon);
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
                log.finest("Received window iconified");
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
                log.finest("Received window deiconified");
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
                log.finest("Received window activated");
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
                log.finest("Received window deactivated");
            }
        };
        return settingsWindowListener;
    }

    private ActionListener getShowNotificationListener(final WindowListener notificationWindowListener) {
        ActionListener showNotificationsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.info("Notifications...");
                String notifs = "";
                long starttime = 0L;
                long endtime = 0L;
                if (OpenGrokTrayApp.this.agentConnected && OpenGrokTrayApp.this.agent != null) {
                    notifs = OpenGrokTrayApp.this.agent.getFilesInfo();
                    OpenGrokTrayApp.this.agent.clearFilesInfo();
                    starttime = OpenGrokTrayApp.this.agent.getStartTime();
                    endtime = OpenGrokTrayApp.this.agent.getEndTime();
                }
                NotificationsFrame sf = new NotificationsFrame(notifs, starttime, endtime);
                sf.addWindowListener(notificationWindowListener);
                sf.setVisible(true);
                log.finest("Done Notifications");
            }
        };
        return showNotificationsListener;
    }

    private void loadImages() {
        URL imageUrl = OpenGrokTrayApp.class.getResource(OPENGROKICONURL);
        this.opengrokImage = Toolkit.getDefaultToolkit().getImage(imageUrl);
        imageUrl = OpenGrokTrayApp.class.getResource(INDEXWARNINGICONURL);
        this.indexWarningImage = Toolkit.getDefaultToolkit().getImage(imageUrl);
        imageUrl = OpenGrokTrayApp.class.getResource(NOCONNECTIONICONURL);
        this.noConnectionImage = Toolkit.getDefaultToolkit().getImage(imageUrl);
    }

    private boolean tryAgentConnect() {
        boolean retval = false;
        try {
            if (this.agent == null) {
                this.agent = new AgentConnection(this.settings.getAgentUrl());
            }
            this.agent.setUrl(this.settings.getAgentUrl());
            this.agent.connect();
            this.agent.registerListener();
            retval = true;
            this.agentConnected = true;
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not connect ", ex);
        }
        return retval;
    }

    private void enableSystemTray() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            MouseListener mouseListener = this.getMouseListener();
            log.info("Creating listeners");
            ActionListener exitListener = this.getExitListener();
            WindowListener settingsWindowListener = this.getSettingsWindowListener();
            WindowListener notificationWindowListener = this.getNotificationWindowListener();
            ActionListener settingsListener = this.getSettingsListener(settingsWindowListener);
            ActionListener showNotificationsListener = this.getShowNotificationListener(notificationWindowListener);
            ActionListener configListener = this.getConfigurationListener();
            log.info("Creating popup and tray icon ");
            PopupMenu popup = new PopupMenu();
            MenuItem exitItem = new MenuItem("Exit");
            exitItem.addActionListener(exitListener);
            MenuItem settingsItem = new MenuItem("Connection Settings");
            settingsItem.addActionListener(settingsListener);
            MenuItem configsItem = new MenuItem("Configurations");
            configsItem.addActionListener(configListener);
            MenuItem notifyItem = new MenuItem("Show notifications");
            notifyItem.addActionListener(showNotificationsListener);
            popup.add(settingsItem);
            popup.add(configsItem);
            popup.add(notifyItem);
            popup.addSeparator();
            popup.add(exitItem);
            trayIcon = new TrayIcon(this.opengrokImage, "OpenGrok Agent Client", popup);
            ActionListener actionListener = this.getAgentActionListener();
            if (this.agent == null || !this.agent.isConnected()) {
                trayIcon.setImage(this.noConnectionImage);
            } else {
                this.agent.setActionListener(actionListener);
            }
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(actionListener);
            trayIcon.addMouseListener(mouseListener);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                log.log(Level.WARNING, "TrayIcon could not be added.", e);
            }
            log.info("Created, ready for action");
        } else {
            log.severe("System Tray is NOT supported");
        }
    }

    static {
        log = OpenGrokLogger.getLogger();
    }
}

