/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DoubleDHT_1D {
    private int n;
    private DoubleFFT_1D fft;

    public DoubleDHT_1D(int n) {
        this.n = n;
        this.fft = new DoubleFFT_1D(n);
    }

    public DoubleDHT_1D(int n, int[] nArray, double[] dArray) {
        this.n = n;
        this.fft = new DoubleFFT_1D(n, nArray, dArray);
    }

    public void forward(double[] dArray) {
        this.forward(dArray, 0);
    }

    public void forward(final double[] dArray, final int n) {
        if (this.n == 1) {
            return;
        }
        this.fft.realForward(dArray, n);
        final double[] dArray2 = new double[this.n];
        System.arraycopy(dArray, n, dArray2, 0, this.n);
        int n2 = this.n / 2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > 1 && n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5 = n2 / n3;
            Future[] futureArray = new Future[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = 1 + n4 * n5;
                final int n7 = n4 == n3 - 1 ? n2 : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            int n3 = 2 * i;
                            int n2 = n3 + 1;
                            dArray[n + i] = dArray2[n3] - dArray2[n2];
                            dArray[n + ((DoubleDHT_1D)DoubleDHT_1D.this).n - i] = dArray2[n3] + dArray2[n2];
                        }
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    futureArray[n4].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n8 = 2 * i;
                int n9 = n8 + 1;
                dArray[n + i] = dArray2[n8] - dArray2[n9];
                dArray[n + this.n - i] = dArray2[n8] + dArray2[n9];
            }
        }
        dArray[n + n2] = dArray2[1];
    }

    public void inverse(double[] dArray, boolean bl) {
        this.inverse(dArray, 0, bl);
    }

    public void inverse(double[] dArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        this.forward(dArray, n);
        if (bl) {
            this.scale(this.n, dArray, n, false);
        }
    }

    private void scale(final double d, final double[] dArray, int n, boolean bl) {
        int n2 = bl ? 2 * this.n : this.n;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            final int n5 = n2 / n3;
            Future[] futureArray = new Future[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n + n4 * n5;
                futureArray[n4] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n6 + n5; i += 2) {
                            int n = i;
                            dArray[n] = dArray[n] / d;
                            int n2 = i + 1;
                            dArray[n2] = dArray[n2] / d;
                        }
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    futureArray[n4].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = n; i < n + n2; i += 2) {
                int n7 = i;
                dArray[n7] = dArray[n7] / d;
                int n8 = i + 1;
                dArray[n8] = dArray[n8] / d;
            }
        }
    }
}

